/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public final class SecurityUtils {
    private SecurityUtils() {
    }

    public static KeyStore getDefaultKeyStore() throws KeyStoreException {
        return KeyStore.getInstance(KeyStore.getDefaultType());
    }

    public static KeyStore getJavaKeyStore() throws KeyStoreException {
        return KeyStore.getInstance("JKS");
    }

    public static KeyStore getPkcs12KeyStore() throws KeyStoreException {
        return KeyStore.getInstance("PKCS12");
    }

    public static PrivateKey getPrivateKey(KeyStore keyStore, String string2, String string3) throws GeneralSecurityException {
        return (PrivateKey)keyStore.getKey(string2, string3.toCharArray());
    }

    public static KeyFactory getRsaKeyFactory() throws NoSuchAlgorithmException {
        return KeyFactory.getInstance("RSA");
    }

    public static Signature getSha1WithRsaSignatureAlgorithm() throws NoSuchAlgorithmException {
        return Signature.getInstance("SHA1withRSA");
    }

    public static Signature getSha256WithRsaSignatureAlgorithm() throws NoSuchAlgorithmException {
        return Signature.getInstance("SHA256withRSA");
    }

    public static CertificateFactory getX509CertificateFactory() throws CertificateException {
        return CertificateFactory.getInstance("X.509");
    }

    public static void loadKeyStore(KeyStore keyStore, InputStream inputStream, String string2) throws IOException, GeneralSecurityException {
        try {
            keyStore.load(inputStream, string2.toCharArray());
            return;
        }
        finally {
            inputStream.close();
        }
    }

    public static void loadKeyStoreFromCertificates(KeyStore keyStore, CertificateFactory certificateFactory, InputStream inputStream) throws GeneralSecurityException {
        int n2 = 0;
        for (Certificate certificate : certificateFactory.generateCertificates(inputStream)) {
            keyStore.setCertificateEntry(String.valueOf(n2), certificate);
            ++n2;
        }
    }

    public static PrivateKey loadPrivateKeyFromKeyStore(KeyStore keyStore, InputStream inputStream, String string2, String string3, String string4) throws IOException, GeneralSecurityException {
        SecurityUtils.loadKeyStore(keyStore, inputStream, string2);
        return SecurityUtils.getPrivateKey(keyStore, string3, string4);
    }

    public static byte[] sign(Signature signature, PrivateKey privateKey, byte[] byArray) throws InvalidKeyException, SignatureException {
        signature.initSign(privateKey);
        signature.update(byArray);
        return signature.sign();
    }

    public static boolean verify(Signature signature, PublicKey publicKey, byte[] byArray, byte[] byArray2) throws InvalidKeyException, SignatureException {
        signature.initVerify(publicKey);
        signature.update(byArray2);
        return signature.verify(byArray);
    }
}

