/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.Base64;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Beta
public final class PemReader {
    private static final Pattern BEGIN_PATTERN = Pattern.compile("-----BEGIN ([A-Z ]+)-----");
    private static final Pattern END_PATTERN = Pattern.compile("-----END ([A-Z ]+)-----");
    private BufferedReader reader;

    public PemReader(Reader reader) {
        this.reader = new BufferedReader(reader);
    }

    public static Section readFirstSectionAndClose(Reader reader) throws IOException {
        return PemReader.readFirstSectionAndClose(reader, null);
    }

    public static Section readFirstSectionAndClose(Reader reader, String string2) throws IOException {
        PemReader pemReader = new PemReader(reader);
        try {
            Section section = pemReader.readNextSection(string2);
            return section;
        }
        finally {
            pemReader.close();
        }
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public Section readNextSection() throws IOException {
        return this.readNextSection(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Section readNextSection(String string2) throws IOException {
        String string3 = null;
        StringBuilder stringBuilder = null;
        while (true) {
            String string4;
            if ((string4 = this.reader.readLine()) == null) {
                boolean bl2 = string3 == null;
                Preconditions.checkArgument(bl2, "missing end tag (%s)", string3);
                return null;
            }
            if (stringBuilder == null) {
                Matcher matcher = BEGIN_PATTERN.matcher(string4);
                if (!matcher.matches()) continue;
                String string5 = matcher.group(1);
                if (string2 != null && !string5.equals(string2)) continue;
                stringBuilder = new StringBuilder();
                string3 = string5;
                continue;
            }
            Matcher matcher = END_PATTERN.matcher(string4);
            if (matcher.matches()) {
                String string6 = matcher.group(1);
                Preconditions.checkArgument(string6.equals(string3), "end tag (%s) doesn't match begin tag (%s)", string6, string3);
                return new Section(string3, Base64.decodeBase64(stringBuilder.toString()));
            }
            stringBuilder.append(string4);
        }
    }

    public static final class Section {
        private final byte[] base64decodedBytes;
        private final String title;

        Section(String string2, byte[] byArray) {
            this.title = Preconditions.checkNotNull(string2);
            this.base64decodedBytes = Preconditions.checkNotNull(byArray);
        }

        public byte[] getBase64DecodedBytes() {
            return this.base64decodedBytes;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

