/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.LoggingByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingInputStream
extends FilterInputStream {
    private final LoggingByteArrayOutputStream logStream;

    public LoggingInputStream(InputStream inputStream, Logger logger, Level level, int n2) {
        super(inputStream);
        this.logStream = new LoggingByteArrayOutputStream(logger, level, n2);
    }

    @Override
    public void close() throws IOException {
        this.logStream.close();
        super.close();
    }

    public final LoggingByteArrayOutputStream getLogStream() {
        return this.logStream;
    }

    @Override
    public int read() throws IOException {
        int n2 = super.read();
        this.logStream.write(n2);
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = super.read(byArray, n2, n3);
        if (n4 > 0) {
            this.logStream.write(byArray, n2, n4);
        }
        return n4;
    }
}

