/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingByteArrayOutputStream
extends ByteArrayOutputStream {
    private int bytesWritten;
    private boolean closed;
    private final Logger logger;
    private final Level loggingLevel;
    private final int maximumBytesToLog;

    /*
     * Enabled aggressive block sorting
     */
    public LoggingByteArrayOutputStream(Logger logger, Level level, int n2) {
        this.logger = Preconditions.checkNotNull(logger);
        this.loggingLevel = Preconditions.checkNotNull(level);
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2);
        this.maximumBytesToLog = n2;
    }

    private static void appendBytes(StringBuilder stringBuilder, int n2) {
        if (n2 == 1) {
            stringBuilder.append("1 byte");
            return;
        }
        stringBuilder.append(NumberFormat.getInstance().format(n2)).append(" bytes");
    }

    @Override
    public void close() throws IOException {
        synchronized (this) {
            if (!this.closed) {
                if (this.bytesWritten != 0) {
                    StringBuilder stringBuilder = new StringBuilder().append("Total: ");
                    LoggingByteArrayOutputStream.appendBytes(stringBuilder, this.bytesWritten);
                    if (this.count != 0 && this.count < this.bytesWritten) {
                        stringBuilder.append(" (logging first ");
                        LoggingByteArrayOutputStream.appendBytes(stringBuilder, this.count);
                        stringBuilder.append(")");
                    }
                    this.logger.config(stringBuilder.toString());
                    if (this.count != 0) {
                        this.logger.log(this.loggingLevel, this.toString("UTF-8").replaceAll("[\\x00-\\x09\\x0B\\x0C\\x0E-\\x1F\\x7F]", " "));
                    }
                }
                this.closed = true;
            }
            return;
        }
    }

    public final int getBytesWritten() {
        synchronized (this) {
            int n2 = this.bytesWritten;
            return n2;
        }
    }

    public final int getMaximumBytesToLog() {
        return this.maximumBytesToLog;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(int n2) {
        synchronized (this) {
            boolean bl2 = !this.closed;
            Preconditions.checkArgument(bl2);
            this.bytesWritten = 1 + this.bytesWritten;
            if (this.count < this.maximumBytesToLog) {
                super.write(n2);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(byte[] byArray, int n2, int n3) {
        synchronized (this) {
            boolean bl2 = !this.closed;
            Preconditions.checkArgument(bl2);
            this.bytesWritten = n3 + this.bytesWritten;
            if (this.count < this.maximumBytesToLog) {
                int n4 = n3 + this.count;
                if (n4 > this.maximumBytesToLog) {
                    n3 += this.maximumBytesToLog - n4;
                }
                super.write(byArray, n2, n3);
            }
            return;
        }
    }
}

