/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public final class Lists {
    private Lists() {
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> iterable) {
        if (iterable instanceof Collection) {
            return new ArrayList<E>(Collections2.cast(iterable));
        }
        return Lists.newArrayList(iterable.iterator());
    }

    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> iterator) {
        ArrayList<E> arrayList = Lists.newArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static <E> ArrayList<E> newArrayListWithCapacity(int n2) {
        return new ArrayList(n2);
    }
}

