/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.Beta;
import com.google.api.client.util.ByteCountingOutputStream;
import com.google.api.client.util.ByteStreams;
import com.google.api.client.util.StreamingContent;
import com.google.api.client.util.Throwables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

public class IOUtils {
    public static long computeLength(StreamingContent streamingContent) throws IOException {
        ByteCountingOutputStream byteCountingOutputStream = new ByteCountingOutputStream();
        try {
            streamingContent.writeTo(byteCountingOutputStream);
            return byteCountingOutputStream.count;
        }
        finally {
            byteCountingOutputStream.close();
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtils.copy(inputStream, outputStream, true);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, boolean bl2) throws IOException {
        try {
            ByteStreams.copy(inputStream, outputStream);
            return;
        }
        finally {
            if (bl2) {
                inputStream.close();
            }
        }
    }

    @Beta
    public static <S extends Serializable> S deserialize(InputStream inputStream) throws IOException {
        try {
            Serializable serializable = (Serializable)new ObjectInputStream(inputStream).readObject();
            return (S)serializable;
        }
        catch (ClassNotFoundException classNotFoundException) {
            IOException iOException = new IOException("Failed to deserialize object");
            iOException.initCause(classNotFoundException);
            throw iOException;
        }
        finally {
            inputStream.close();
        }
    }

    @Beta
    public static <S extends Serializable> S deserialize(byte[] byArray) throws IOException {
        if (byArray == null) {
            return null;
        }
        return IOUtils.deserialize(new ByteArrayInputStream(byArray));
    }

    /*
     * Unable to fully structure code
     */
    @Beta
    public static boolean isSymbolicLink(File var0) throws IOException {
        try {
            var12_1 = Class.forName("java.nio.file.Files");
            var13_2 = Class.forName("java.nio.file.Path");
            var14_3 = File.class.getMethod("toPath", new Class[0]).invoke((Object)var0, new Object[0]);
            var3_5 = var15_4 = ((Boolean)var12_1.getMethod("isSymbolicLink", new Class[]{var13_2}).invoke(null, new Object[]{var14_3})).booleanValue();
            return var3_5;
        }
        catch (InvocationTargetException var10_6) {
            var11_7 = var10_6.getCause();
            Throwables.propagateIfPossible(var11_7, IOException.class);
            throw new RuntimeException(var11_7);
        }
        catch (NoSuchMethodException var9_8) lbl-1000:
        // 5 sources

        {
            while (true) {
                var2_9 = File.separatorChar;
                var3_5 = false;
                if (var2_9 == '\\') ** continue;
                var4_10 = var0;
                if (var0.getParent() != null) {
                    var4_10 = new File(var0.getParentFile().getCanonicalFile(), var0.getName());
                }
                if (!var4_10.getCanonicalFile().equals(var4_10.getAbsoluteFile())) {
                    var5_11 = true;
lbl22:
                    // 2 sources

                    return var5_11;
                }
                var5_11 = false;
                ** continue;
                break;
            }
        }
        catch (IllegalAccessException var8_12) {
            ** GOTO lbl-1000
        }
        catch (SecurityException var7_13) {
            ** GOTO lbl-1000
        }
        catch (IllegalArgumentException var6_14) {
            ** GOTO lbl-1000
        }
        catch (ClassNotFoundException var1_15) {
            ** continue;
        }
    }

    @Beta
    public static void serialize(Object object, OutputStream outputStream) throws IOException {
        try {
            new ObjectOutputStream(outputStream).writeObject(object);
            return;
        }
        finally {
            outputStream.close();
        }
    }

    @Beta
    public static byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.serialize(object, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

