/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.NullValue;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Value;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.WeakHashMap;

public class FieldInfo {
    private static final Map<Field, FieldInfo> CACHE = new WeakHashMap<Field, FieldInfo>();
    private final Field field;
    private final boolean isPrimitive;
    private final String name;

    /*
     * Enabled aggressive block sorting
     */
    FieldInfo(Field field, String string2) {
        this.field = field;
        String string3 = string2 == null ? null : string2.intern();
        this.name = string3;
        this.isPrimitive = Data.isPrimitive(this.getType());
    }

    public static Object getFieldValue(Field field, Object object) {
        try {
            Object object2 = field.get(object);
            return object2;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FieldInfo of(Enum<?> enum_) {
        boolean bl2 = true;
        try {
            FieldInfo fieldInfo = FieldInfo.of(enum_.getClass().getField(enum_.name()));
            if (fieldInfo == null) {
                bl2 = false;
            }
            Preconditions.checkArgument(bl2, "enum constant missing @Value or @NullValue annotation: %s", enum_);
            return fieldInfo;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FieldInfo of(Field field) {
        if (field == null) {
            return null;
        }
        Map<Field, FieldInfo> map = CACHE;
        synchronized (map) {
            FieldInfo fieldInfo = CACHE.get(field);
            boolean bl2 = field.isEnumConstant();
            if (fieldInfo == null && (bl2 || !Modifier.isStatic(field.getModifiers()))) {
                String string2;
                if (bl2) {
                    Value value = field.getAnnotation(Value.class);
                    if (value != null) {
                        string2 = value.value();
                    } else {
                        if (field.getAnnotation(NullValue.class) == null) {
                            return null;
                        }
                        string2 = null;
                    }
                } else {
                    Key key = field.getAnnotation(Key.class);
                    if (key == null) {
                        return null;
                    }
                    string2 = key.value();
                    field.setAccessible(true);
                }
                if ("##default".equals(string2)) {
                    string2 = field.getName();
                }
                fieldInfo = new FieldInfo(field, string2);
                CACHE.put(field, fieldInfo);
            }
            return fieldInfo;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setFieldValue(Field field, Object object, Object object2) {
        if (Modifier.isFinal(field.getModifiers())) {
            Object object3 = FieldInfo.getFieldValue(field, object);
            if (object2 == null ? object3 != null : !object2.equals(object3)) {
                throw new IllegalArgumentException("expected final value <" + object3 + "> but was <" + object2 + "> on " + field.getName() + " field in " + object.getClass().getName());
            }
            return;
        }
        try {
            field.set(object, object2);
            return;
        }
        catch (SecurityException securityException) {
            throw new IllegalArgumentException(securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException);
        }
    }

    public <T extends Enum<T>> T enumValue() {
        return (T)Enum.valueOf(this.field.getDeclaringClass(), this.field.getName());
    }

    public ClassInfo getClassInfo() {
        return ClassInfo.of(this.field.getDeclaringClass());
    }

    public Field getField() {
        return this.field;
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public Object getValue(Object object) {
        return FieldInfo.getFieldValue(this.field, object);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public void setValue(Object object, Object object2) {
        FieldInfo.setFieldValue(this.field, object, object2);
    }
}

