/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.NanoClock;
import com.google.api.client.util.Preconditions;
import java.io.IOException;

public class ExponentialBackOff
implements BackOff {
    public static final int DEFAULT_INITIAL_INTERVAL_MILLIS = 500;
    public static final int DEFAULT_MAX_ELAPSED_TIME_MILLIS = 900000;
    public static final int DEFAULT_MAX_INTERVAL_MILLIS = 60000;
    public static final double DEFAULT_MULTIPLIER = 1.5;
    public static final double DEFAULT_RANDOMIZATION_FACTOR = 0.5;
    private int currentIntervalMillis;
    private final int initialIntervalMillis;
    private final int maxElapsedTimeMillis;
    private final int maxIntervalMillis;
    private final double multiplier;
    private final NanoClock nanoClock;
    private final double randomizationFactor;
    long startTimeNanos;

    public ExponentialBackOff() {
        this(new Builder());
    }

    /*
     * Enabled aggressive block sorting
     */
    protected ExponentialBackOff(Builder builder) {
        boolean bl2 = true;
        this.initialIntervalMillis = builder.initialIntervalMillis;
        this.randomizationFactor = builder.randomizationFactor;
        this.multiplier = builder.multiplier;
        this.maxIntervalMillis = builder.maxIntervalMillis;
        this.maxElapsedTimeMillis = builder.maxElapsedTimeMillis;
        this.nanoClock = builder.nanoClock;
        boolean bl3 = this.initialIntervalMillis > 0 ? bl2 : false;
        Preconditions.checkArgument(bl3);
        boolean bl4 = 0.0 <= this.randomizationFactor && this.randomizationFactor < 1.0 ? bl2 : false;
        Preconditions.checkArgument(bl4);
        boolean bl5 = this.multiplier >= 1.0 ? bl2 : false;
        Preconditions.checkArgument(bl5);
        boolean bl6 = this.maxIntervalMillis >= this.initialIntervalMillis ? bl2 : false;
        Preconditions.checkArgument(bl6);
        if (this.maxElapsedTimeMillis <= 0) {
            bl2 = false;
        }
        Preconditions.checkArgument(bl2);
        this.reset();
    }

    static int getRandomValueFromInterval(double d2, double d3, int n2) {
        double d4 = d2 * (double)n2;
        double d5 = (double)n2 - d4;
        return (int)(d5 + d3 * (1.0 + (d4 + (double)n2 - d5)));
    }

    private void incrementCurrentInterval() {
        if ((double)this.currentIntervalMillis >= (double)this.maxIntervalMillis / this.multiplier) {
            this.currentIntervalMillis = this.maxIntervalMillis;
            return;
        }
        this.currentIntervalMillis = (int)((double)this.currentIntervalMillis * this.multiplier);
    }

    public final int getCurrentIntervalMillis() {
        return this.currentIntervalMillis;
    }

    public final long getElapsedTimeMillis() {
        return (this.nanoClock.nanoTime() - this.startTimeNanos) / 1000000L;
    }

    public final int getInitialIntervalMillis() {
        return this.initialIntervalMillis;
    }

    public final int getMaxElapsedTimeMillis() {
        return this.maxElapsedTimeMillis;
    }

    public final int getMaxIntervalMillis() {
        return this.maxIntervalMillis;
    }

    public final double getMultiplier() {
        return this.multiplier;
    }

    public final double getRandomizationFactor() {
        return this.randomizationFactor;
    }

    @Override
    public long nextBackOffMillis() throws IOException {
        if (this.getElapsedTimeMillis() > (long)this.maxElapsedTimeMillis) {
            return -1L;
        }
        int n2 = ExponentialBackOff.getRandomValueFromInterval(this.randomizationFactor, Math.random(), this.currentIntervalMillis);
        this.incrementCurrentInterval();
        return n2;
    }

    @Override
    public final void reset() {
        this.currentIntervalMillis = this.initialIntervalMillis;
        this.startTimeNanos = this.nanoClock.nanoTime();
    }

    public static class Builder {
        int initialIntervalMillis = 500;
        int maxElapsedTimeMillis = 900000;
        int maxIntervalMillis = 60000;
        double multiplier = 1.5;
        NanoClock nanoClock = NanoClock.SYSTEM;
        double randomizationFactor = 0.5;

        public ExponentialBackOff build() {
            return new ExponentialBackOff(this);
        }

        public final int getInitialIntervalMillis() {
            return this.initialIntervalMillis;
        }

        public final int getMaxElapsedTimeMillis() {
            return this.maxElapsedTimeMillis;
        }

        public final int getMaxIntervalMillis() {
            return this.maxIntervalMillis;
        }

        public final double getMultiplier() {
            return this.multiplier;
        }

        public final NanoClock getNanoClock() {
            return this.nanoClock;
        }

        public final double getRandomizationFactor() {
            return this.randomizationFactor;
        }

        public Builder setInitialIntervalMillis(int n2) {
            this.initialIntervalMillis = n2;
            return this;
        }

        public Builder setMaxElapsedTimeMillis(int n2) {
            this.maxElapsedTimeMillis = n2;
            return this;
        }

        public Builder setMaxIntervalMillis(int n2) {
            this.maxIntervalMillis = n2;
            return this;
        }

        public Builder setMultiplier(double d2) {
            this.multiplier = d2;
            return this;
        }

        public Builder setNanoClock(NanoClock nanoClock) {
            this.nanoClock = Preconditions.checkNotNull(nanoClock);
            return this;
        }

        public Builder setRandomizationFactor(double d2) {
            this.randomizationFactor = d2;
            return this;
        }
    }
}

