/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DateTime
implements Serializable {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final Pattern RFC3339_PATTERN = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})([Tt](\\d{2}):(\\d{2}):(\\d{2})(\\.\\d+)?)?([Zz]|([+-])(\\d{2}):(\\d{2}))?");
    private static final long serialVersionUID = 1L;
    private final boolean dateOnly;
    private final int tzShift;
    private final long value;

    public DateTime(long l2) {
        this(false, l2, null);
    }

    public DateTime(long l2, int n2) {
        this(false, l2, n2);
    }

    public DateTime(String string2) {
        DateTime dateTime = DateTime.parseRfc3339(string2);
        this.dateOnly = dateTime.dateOnly;
        this.value = dateTime.value;
        this.tzShift = dateTime.tzShift;
    }

    public DateTime(Date date) {
        this(date.getTime());
    }

    /*
     * Enabled aggressive block sorting
     */
    public DateTime(Date date, TimeZone timeZone) {
        long l2 = date.getTime();
        Integer n2 = timeZone == null ? null : Integer.valueOf(timeZone.getOffset(date.getTime()) / 60000);
        this(false, l2, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public DateTime(boolean bl2, long l2, Integer n2) {
        this.dateOnly = bl2;
        this.value = l2;
        int n3 = bl2 ? 0 : (n2 == null ? TimeZone.getDefault().getOffset(l2) / 60000 : n2);
        this.tzShift = n3;
    }

    private static void appendInt(StringBuilder stringBuilder, int n2, int n3) {
        if (n2 < 0) {
            stringBuilder.append('-');
            n2 = -n2;
        }
        int n4 = n2;
        while (n4 > 0) {
            n4 /= 10;
            --n3;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuilder.append('0');
        }
        if (n2 != 0) {
            stringBuilder.append(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static DateTime parseRfc3339(String string2) throws NumberFormatException {
        Matcher matcher = RFC3339_PATTERN.matcher(string2);
        if (!matcher.matches()) {
            throw new NumberFormatException("Invalid date/time format: " + string2);
        }
        int n2 = Integer.parseInt(matcher.group(1));
        int n3 = -1 + Integer.parseInt(matcher.group(2));
        int n4 = Integer.parseInt(matcher.group(3));
        boolean bl2 = matcher.group(4) != null;
        String string3 = matcher.group(9);
        boolean bl3 = string3 != null;
        if (bl3 && !bl2) {
            throw new NumberFormatException("Invalid date/time format, cannot specify time zone shift without specifying time: " + string2);
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (bl2) {
            n5 = Integer.parseInt(matcher.group(5));
            n6 = Integer.parseInt(matcher.group(6));
            n7 = Integer.parseInt(matcher.group(7));
            String string4 = matcher.group(8);
            n8 = 0;
            if (string4 != null) {
                n8 = Integer.parseInt(matcher.group(8).substring(1));
            }
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(GMT);
        gregorianCalendar.set(n2, n3, n4, n5, n6, n7);
        gregorianCalendar.set(14, n8);
        long l2 = gregorianCalendar.getTimeInMillis();
        Integer n9 = null;
        if (bl2) {
            n9 = null;
            if (bl3) {
                int n10;
                if (Character.toUpperCase(string3.charAt(0)) == 'Z') {
                    n10 = 0;
                } else {
                    n10 = 60 * Integer.parseInt(matcher.group(11)) + Integer.parseInt(matcher.group(12));
                    if (matcher.group(10).charAt(0) == '-') {
                        n10 = -n10;
                    }
                    l2 -= 60000L * (long)n10;
                }
                n9 = n10;
            }
        }
        boolean bl4 = !bl2;
        return new DateTime(bl4, l2, n9);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (object == this) break block4;
                if (!(object instanceof DateTime)) {
                    return false;
                }
                DateTime dateTime = (DateTime)object;
                if (this.dateOnly != dateTime.dateOnly || this.value != dateTime.value || this.tzShift != dateTime.tzShift) break block5;
            }
            return true;
        }
        return false;
    }

    public int getTimeZoneShift() {
        return this.tzShift;
    }

    public long getValue() {
        return this.value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        long[] lArray = new long[3];
        lArray[0] = this.value;
        long l2 = this.dateOnly ? 1L : 0L;
        lArray[1] = l2;
        lArray[2] = this.tzShift;
        return Arrays.hashCode(lArray);
    }

    public boolean isDateOnly() {
        return this.dateOnly;
    }

    public String toString() {
        return this.toStringRfc3339();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toStringRfc3339() {
        StringBuilder stringBuilder = new StringBuilder();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(GMT);
        gregorianCalendar.setTimeInMillis(this.value + 60000L * (long)this.tzShift);
        DateTime.appendInt(stringBuilder, gregorianCalendar.get(1), 4);
        stringBuilder.append('-');
        DateTime.appendInt(stringBuilder, 1 + gregorianCalendar.get(2), 2);
        stringBuilder.append('-');
        DateTime.appendInt(stringBuilder, gregorianCalendar.get(5), 2);
        if (this.dateOnly) return stringBuilder.toString();
        stringBuilder.append('T');
        DateTime.appendInt(stringBuilder, gregorianCalendar.get(11), 2);
        stringBuilder.append(':');
        DateTime.appendInt(stringBuilder, gregorianCalendar.get(12), 2);
        stringBuilder.append(':');
        DateTime.appendInt(stringBuilder, gregorianCalendar.get(13), 2);
        if (gregorianCalendar.isSet(14)) {
            stringBuilder.append('.');
            DateTime.appendInt(stringBuilder, gregorianCalendar.get(14), 3);
        }
        if (this.tzShift == 0) {
            stringBuilder.append('Z');
            return stringBuilder.toString();
        }
        int n2 = this.tzShift;
        if (this.tzShift > 0) {
            stringBuilder.append('+');
        } else {
            stringBuilder.append('-');
            n2 = -n2;
        }
        int n3 = n2 / 60;
        int n4 = n2 % 60;
        DateTime.appendInt(stringBuilder, n3, 2);
        stringBuilder.append(':');
        DateTime.appendInt(stringBuilder, n4, 2);
        return stringBuilder.toString();
    }
}

