/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.Preconditions;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

final class DataMap
extends AbstractMap<String, Object> {
    final ClassInfo classInfo;
    final Object object;

    /*
     * Enabled aggressive block sorting
     */
    DataMap(Object object, boolean bl2) {
        this.object = object;
        this.classInfo = ClassInfo.of(object.getClass(), bl2);
        boolean bl3 = !this.classInfo.isEnum();
        Preconditions.checkArgument(bl3);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public EntrySet entrySet() {
        return new EntrySet();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object get(Object object) {
        FieldInfo fieldInfo;
        if (!(object instanceof String) || (fieldInfo = this.classInfo.getFieldInfo((String)object)) == null) {
            return null;
        }
        return fieldInfo.getValue(this.object);
    }

    @Override
    public Object put(String string2, Object object) {
        FieldInfo fieldInfo = this.classInfo.getFieldInfo(string2);
        Preconditions.checkNotNull(fieldInfo, "no field of key " + string2);
        Object object2 = fieldInfo.getValue(this.object);
        fieldInfo.setValue(this.object, Preconditions.checkNotNull(object));
        return object2;
    }

    final class Entry
    implements Map.Entry<String, Object> {
        private final FieldInfo fieldInfo;
        private Object fieldValue;

        Entry(FieldInfo fieldInfo, Object object) {
            this.fieldInfo = fieldInfo;
            this.fieldValue = Preconditions.checkNotNull(object);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean equals(Object object) {
            block5: {
                block4: {
                    if (this == object) break block4;
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    if (!((String)this.getKey()).equals(entry.getKey()) || !this.getValue().equals(entry.getValue())) break block5;
                }
                return true;
            }
            return false;
        }

        @Override
        public String getKey() {
            String string2 = this.fieldInfo.getName();
            if (DataMap.this.classInfo.getIgnoreCase()) {
                string2 = string2.toLowerCase();
            }
            return string2;
        }

        @Override
        public Object getValue() {
            return this.fieldValue;
        }

        @Override
        public int hashCode() {
            return ((String)this.getKey()).hashCode() ^ this.getValue().hashCode();
        }

        @Override
        public Object setValue(Object object) {
            Object object2 = this.fieldValue;
            this.fieldValue = Preconditions.checkNotNull(object);
            this.fieldInfo.setValue(DataMap.this.object, object);
            return object2;
        }
    }

    final class EntryIterator
    implements Iterator<Map.Entry<String, Object>> {
        private FieldInfo currentFieldInfo;
        private boolean isComputed;
        private boolean isRemoved;
        private FieldInfo nextFieldInfo;
        private Object nextFieldValue;
        private int nextKeyIndex = -1;

        EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            if (!this.isComputed) {
                this.isComputed = true;
                this.nextFieldValue = null;
                while (this.nextFieldValue == null) {
                    int n2;
                    this.nextKeyIndex = n2 = 1 + this.nextKeyIndex;
                    if (n2 >= DataMap.this.classInfo.names.size()) break;
                    this.nextFieldInfo = DataMap.this.classInfo.getFieldInfo(DataMap.this.classInfo.names.get(this.nextKeyIndex));
                    this.nextFieldValue = this.nextFieldInfo.getValue(DataMap.this.object);
                }
            }
            return this.nextFieldValue != null;
        }

        @Override
        public Map.Entry<String, Object> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentFieldInfo = this.nextFieldInfo;
            Object object = this.nextFieldValue;
            this.isComputed = false;
            this.isRemoved = false;
            this.nextFieldInfo = null;
            this.nextFieldValue = null;
            return new Entry(this.currentFieldInfo, object);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void remove() {
            boolean bl2 = this.currentFieldInfo != null && !this.isRemoved;
            Preconditions.checkState(bl2);
            this.isRemoved = true;
            this.currentFieldInfo.setValue(DataMap.this.object, null);
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        EntrySet() {
        }

        @Override
        public void clear() {
            for (String string2 : DataMap.this.classInfo.names) {
                DataMap.this.classInfo.getFieldInfo(string2).setValue(DataMap.this.object, null);
            }
        }

        @Override
        public boolean isEmpty() {
            for (String string2 : DataMap.this.classInfo.names) {
                if (DataMap.this.classInfo.getFieldInfo(string2).getValue(DataMap.this.object) == null) continue;
                return false;
            }
            return true;
        }

        public EntryIterator iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            int n2 = 0;
            for (String string2 : DataMap.this.classInfo.names) {
                if (DataMap.this.classInfo.getFieldInfo(string2).getValue(DataMap.this.object) == null) continue;
                ++n2;
            }
            return n2;
        }
    }
}

