/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.ArrayMap;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.DataMap;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Types;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class Data {
    public static final BigDecimal NULL_BIG_DECIMAL;
    public static final BigInteger NULL_BIG_INTEGER;
    public static final Boolean NULL_BOOLEAN;
    public static final Byte NULL_BYTE;
    private static final ConcurrentHashMap<Class<?>, Object> NULL_CACHE;
    public static final Character NULL_CHARACTER;
    public static final DateTime NULL_DATE_TIME;
    public static final Double NULL_DOUBLE;
    public static final Float NULL_FLOAT;
    public static final Integer NULL_INTEGER;
    public static final Long NULL_LONG;
    public static final Short NULL_SHORT;
    public static final String NULL_STRING;

    static {
        NULL_BOOLEAN = new Boolean(true);
        NULL_STRING = new String();
        NULL_CHARACTER = new Character('\u0000');
        NULL_BYTE = new Byte(0);
        NULL_SHORT = new Short(0);
        NULL_INTEGER = new Integer(0);
        NULL_FLOAT = new Float(0.0f);
        NULL_LONG = new Long(0L);
        NULL_DOUBLE = new Double(0.0);
        NULL_BIG_INTEGER = new BigInteger("0");
        NULL_BIG_DECIMAL = new BigDecimal("0");
        NULL_DATE_TIME = new DateTime(0L);
        NULL_CACHE = new ConcurrentHashMap();
        NULL_CACHE.put(Boolean.class, NULL_BOOLEAN);
        NULL_CACHE.put(String.class, NULL_STRING);
        NULL_CACHE.put(Character.class, NULL_CHARACTER);
        NULL_CACHE.put(Byte.class, NULL_BYTE);
        NULL_CACHE.put(Short.class, NULL_SHORT);
        NULL_CACHE.put(Integer.class, NULL_INTEGER);
        NULL_CACHE.put(Float.class, NULL_FLOAT);
        NULL_CACHE.put(Long.class, NULL_LONG);
        NULL_CACHE.put(Double.class, NULL_DOUBLE);
        NULL_CACHE.put(BigInteger.class, NULL_BIG_INTEGER);
        NULL_CACHE.put(BigDecimal.class, NULL_BIG_DECIMAL);
        NULL_CACHE.put(DateTime.class, NULL_DATE_TIME);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T> T clone(T t2) {
        if (t2 == null || Data.isPrimitive(t2.getClass())) {
            return t2;
        }
        if (t2 instanceof GenericData) {
            return (T)((GenericData)t2).clone();
        }
        Class<?> clazz = t2.getClass();
        Object object = clazz.isArray() ? Array.newInstance(clazz.getComponentType(), Array.getLength(t2)) : (t2 instanceof ArrayMap ? ((ArrayMap)t2).clone() : Types.newInstance(clazz));
        Data.deepCopy(t2, object);
        return (T)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void deepCopy(Object object, Object object2) {
        Class<?> clazz = object.getClass();
        boolean bl2 = clazz == object2.getClass();
        Preconditions.checkArgument(bl2);
        if (clazz.isArray()) {
            boolean bl3 = Array.getLength(object) == Array.getLength(object2);
            Preconditions.checkArgument(bl3);
            int n2 = 0;
            for (Object t2 : Types.iterableOf(object)) {
                int n3 = n2 + 1;
                Array.set(object2, n2, Data.clone(t2));
                n2 = n3;
            }
            return;
        } else if (Collection.class.isAssignableFrom(clazz)) {
            Collection collection = (Collection)object;
            if (ArrayList.class.isAssignableFrom(clazz)) {
                ((ArrayList)object2).ensureCapacity(collection.size());
            }
            Collection collection2 = (Collection)object2;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                collection2.add(Data.clone(iterator.next()));
            }
            return;
        } else {
            boolean bl4 = GenericData.class.isAssignableFrom(clazz);
            if (bl4 || !Map.class.isAssignableFrom(clazz)) {
                ClassInfo classInfo = bl4 ? ((GenericData)object).classInfo : ClassInfo.of(clazz);
                Iterator<String> iterator = classInfo.names.iterator();
                while (iterator.hasNext()) {
                    Object object3;
                    FieldInfo fieldInfo = classInfo.getFieldInfo(iterator.next());
                    if (fieldInfo.isFinal() || bl4 && fieldInfo.isPrimitive() || (object3 = fieldInfo.getValue(object)) == null) continue;
                    fieldInfo.setValue(object2, Data.clone(object3));
                }
                return;
            } else if (ArrayMap.class.isAssignableFrom(clazz)) {
                ArrayMap arrayMap = (ArrayMap)object2;
                ArrayMap arrayMap2 = (ArrayMap)object;
                int n4 = arrayMap2.size();
                for (int i2 = 0; i2 < n4; ++i2) {
                    arrayMap.set(i2, Data.clone(arrayMap2.getValue(i2)));
                }
                return;
            } else {
                Map map = (Map)object2;
                for (Map.Entry entry : ((Map)object).entrySet()) {
                    map.put(entry.getKey(), Data.clone(entry.getValue()));
                }
            }
        }
    }

    public static boolean isNull(Object object) {
        return object != null && object == NULL_CACHE.get(object.getClass());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isPrimitive(Type type) {
        Class clazz;
        if (type instanceof WildcardType) {
            type = Types.getBound((WildcardType)type);
        }
        return type instanceof Class && ((clazz = (Class)type).isPrimitive() || clazz == Character.class || clazz == String.class || clazz == Integer.class || clazz == Long.class || clazz == Short.class || clazz == Byte.class || clazz == Float.class || clazz == Double.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == DateTime.class || clazz == Boolean.class);
    }

    public static boolean isValueOfPrimitiveType(Object object) {
        return object == null || Data.isPrimitive(object.getClass());
    }

    public static Map<String, Object> mapOf(Object object) {
        if (object == null || Data.isNull(object)) {
            return Collections.emptyMap();
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        return new DataMap(object, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Collection<Object> newCollectionInstance(Type type) {
        if (type instanceof WildcardType) {
            type = Types.getBound((WildcardType)type);
        }
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        Class clazz = type instanceof Class ? (Class)type : null;
        if (type == null || type instanceof GenericArrayType || clazz != null && (clazz.isArray() || clazz.isAssignableFrom(ArrayList.class))) {
            return new ArrayList<Object>();
        }
        if (clazz == null) {
            throw new IllegalArgumentException("unable to create new instance of type: " + type);
        }
        if (clazz.isAssignableFrom(HashSet.class)) {
            return new HashSet<Object>();
        }
        if (clazz.isAssignableFrom(TreeSet.class)) {
            return new TreeSet<Object>();
        }
        return (Collection)Types.newInstance(clazz);
    }

    public static Map<String, Object> newMapInstance(Class<?> clazz) {
        if (clazz == null || clazz.isAssignableFrom(ArrayMap.class)) {
            return ArrayMap.create();
        }
        if (clazz.isAssignableFrom(TreeMap.class)) {
            return new TreeMap<String, Object>();
        }
        return (Map)Types.newInstance(clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T nullOf(Class<?> clazz) {
        Object object = NULL_CACHE.get(clazz);
        if (object != null) {
            return (T)object;
        }
        ConcurrentHashMap<Class<?>, Object> concurrentHashMap = NULL_CACHE;
        synchronized (concurrentHashMap) {
            Object object2;
            Object object3 = NULL_CACHE.get(clazz);
            if (object3 == null) {
                Object object4;
                if (clazz.isArray()) {
                    int n2 = 0;
                    Class<?> clazz2 = clazz;
                    do {
                        clazz2 = clazz2.getComponentType();
                        ++n2;
                    } while (clazz2.isArray());
                    object4 = Array.newInstance(clazz2, new int[n2]);
                } else if (clazz.isEnum()) {
                    FieldInfo fieldInfo = ClassInfo.of(clazz).getFieldInfo(null);
                    Preconditions.checkNotNull(fieldInfo, "enum missing constant with @NullValue annotation: %s", clazz);
                    object4 = fieldInfo.enumValue();
                } else {
                    object4 = Types.newInstance(clazz);
                }
                NULL_CACHE.put(clazz, object4);
                object2 = object4;
            } else {
                object2 = object3;
            }
            return (T)object2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object parsePrimitiveValue(Type type, String string2) {
        Class clazz = type instanceof Class ? (Class)type : null;
        if (type == null || clazz != null) {
            if (clazz == Void.class) {
                return null;
            }
            if (string2 == null || clazz == null || clazz.isAssignableFrom(String.class)) {
                return string2;
            }
            if (clazz == Character.class || clazz == Character.TYPE) {
                if (string2.length() != 1) {
                    throw new IllegalArgumentException("expected type Character/char but got " + clazz);
                }
                return Character.valueOf(string2.charAt(0));
            }
            if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                return Boolean.valueOf(string2);
            }
            if (clazz == Byte.class || clazz == Byte.TYPE) {
                return Byte.valueOf(string2);
            }
            if (clazz == Short.class || clazz == Short.TYPE) {
                return Short.valueOf(string2);
            }
            if (clazz == Integer.class || clazz == Integer.TYPE) {
                return Integer.valueOf(string2);
            }
            if (clazz == Long.class || clazz == Long.TYPE) {
                return Long.valueOf(string2);
            }
            if (clazz == Float.class || clazz == Float.TYPE) {
                return Float.valueOf(string2);
            }
            if (clazz == Double.class || clazz == Double.TYPE) {
                return Double.valueOf(string2);
            }
            if (clazz == DateTime.class) {
                return DateTime.parseRfc3339(string2);
            }
            if (clazz == BigInteger.class) {
                return new BigInteger(string2);
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal(string2);
            }
            if (clazz.isEnum()) {
                return ClassInfo.of(clazz).getFieldInfo(string2).enumValue();
            }
        }
        throw new IllegalArgumentException("expected primitive class, but got: " + type);
    }

    public static Type resolveWildcardTypeOrTypeVariable(List<Type> list, Type type) {
        if (type instanceof WildcardType) {
            type = Types.getBound((WildcardType)type);
        }
        while (type instanceof TypeVariable) {
            Type type2 = Types.resolveTypeVariable(list, (TypeVariable)type);
            if (type2 != null) {
                type = type2;
            }
            if (!(type instanceof TypeVariable)) continue;
            type = ((TypeVariable)type).getBounds()[0];
        }
        return type;
    }
}

