/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.Preconditions;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;

public final class ClassInfo {
    private static final Map<Class<?>, ClassInfo> CACHE = new WeakHashMap();
    private static final Map<Class<?>, ClassInfo> CACHE_IGNORE_CASE = new WeakHashMap();
    private final Class<?> clazz;
    private final boolean ignoreCase;
    private final IdentityHashMap<String, FieldInfo> nameToFieldInfoMap = new IdentityHashMap();
    final List<String> names;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private ClassInfo(Class<?> clazz, boolean bl2) {
        void var9_22;
        this.clazz = clazz;
        this.ignoreCase = bl2;
        boolean bl3 = !bl2 || !clazz.isEnum();
        Preconditions.checkArgument(bl3, "cannot ignore case on an enum: " + clazz);
        TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String string2, String string3) {
                if (string2 == string3) {
                    return 0;
                }
                if (string2 == null) {
                    return -1;
                }
                if (string3 == null) {
                    return 1;
                }
                return string2.compareTo(string3);
            }
        });
        for (Field field : clazz.getDeclaredFields()) {
            FieldInfo fieldInfo;
            FieldInfo fieldInfo2 = FieldInfo.of(field);
            if (fieldInfo2 == null) continue;
            String string2 = fieldInfo2.getName();
            if (bl2) {
                string2 = string2.toLowerCase().intern();
            }
            boolean bl4 = (fieldInfo = this.nameToFieldInfoMap.get(string2)) == null;
            Object[] objectArray = new Object[4];
            String string3 = bl2 ? "case-insensitive " : "";
            objectArray[0] = string3;
            objectArray[1] = string2;
            objectArray[2] = field;
            Field field2 = fieldInfo == null ? null : fieldInfo.getField();
            objectArray[3] = field2;
            Preconditions.checkArgument(bl4, "two fields have the same %sname <%s>: %s and %s", objectArray);
            this.nameToFieldInfoMap.put(string2, fieldInfo2);
            treeSet.add(string2);
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            ClassInfo classInfo = ClassInfo.of(clazz2, bl2);
            treeSet.addAll(classInfo.names);
            for (Map.Entry<String, FieldInfo> entry : classInfo.nameToFieldInfoMap.entrySet()) {
                String string4 = entry.getKey();
                if (this.nameToFieldInfoMap.containsKey(string4)) continue;
                this.nameToFieldInfoMap.put(string4, entry.getValue());
            }
        }
        if (treeSet.isEmpty()) {
            List list = Collections.emptyList();
        } else {
            List<String> list = Collections.unmodifiableList(new ArrayList<String>(treeSet));
        }
        this.names = var9_22;
    }

    public static ClassInfo of(Class<?> clazz) {
        return ClassInfo.of(clazz, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClassInfo of(Class<?> clazz, boolean bl2) {
        if (clazz == null) {
            return null;
        }
        Map<Class<?>, ClassInfo> map = bl2 ? CACHE_IGNORE_CASE : CACHE;
        synchronized (map) {
            ClassInfo classInfo = map.get(clazz);
            if (classInfo == null) {
                classInfo = new ClassInfo(clazz, bl2);
                map.put(clazz, classInfo);
            }
            return classInfo;
        }
    }

    public Field getField(String string2) {
        FieldInfo fieldInfo = this.getFieldInfo(string2);
        if (fieldInfo == null) {
            return null;
        }
        return fieldInfo.getField();
    }

    public FieldInfo getFieldInfo(String string2) {
        if (string2 != null) {
            if (this.ignoreCase) {
                string2 = string2.toLowerCase();
            }
            string2 = string2.intern();
        }
        return this.nameToFieldInfoMap.get(string2);
    }

    public Collection<FieldInfo> getFieldInfos() {
        return Collections.unmodifiableCollection(this.nameToFieldInfoMap.values());
    }

    public final boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public Collection<String> getNames() {
        return this.names;
    }

    public Class<?> getUnderlyingClass() {
        return this.clazz;
    }

    public boolean isEnum() {
        return this.clazz.isEnum();
    }
}

