/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.Preconditions;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ByteStreams {
    private static final int BUF_SIZE = 4096;

    private ByteStreams() {
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        Preconditions.checkNotNull(inputStream);
        Preconditions.checkNotNull(outputStream);
        byte[] byArray = new byte[4096];
        long l2 = 0L;
        int n2;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static InputStream limit(InputStream inputStream, long l2) {
        return new LimitedInputStream(inputStream, l2);
    }

    public static int read(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        Preconditions.checkNotNull(inputStream);
        Preconditions.checkNotNull(byArray);
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        int n4 = 0;
        int n5;
        while (n4 < n3 && (n5 = inputStream.read(byArray, n2 + n4, n3 - n4)) != -1) {
            n4 += n5;
        }
        return n4;
    }

    private static final class LimitedInputStream
    extends FilterInputStream {
        private long left;
        private long mark = -1L;

        /*
         * Enabled aggressive block sorting
         */
        LimitedInputStream(InputStream inputStream, long l2) {
            super(inputStream);
            Preconditions.checkNotNull(inputStream);
            boolean bl2 = l2 >= 0L;
            Preconditions.checkArgument(bl2, "limit must be non-negative");
            this.left = l2;
        }

        @Override
        public int available() throws IOException {
            return (int)Math.min((long)this.in.available(), this.left);
        }

        @Override
        public void mark(int n2) {
            synchronized (this) {
                this.in.mark(n2);
                this.mark = this.left;
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read() throws IOException {
            if (this.left == 0L) {
                return -1;
            }
            int n2 = this.in.read();
            if (n2 == -1) return n2;
            --this.left;
            return n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (this.left == 0L) {
                return -1;
            }
            int n4 = (int)Math.min((long)n3, this.left);
            int n5 = this.in.read(byArray, n2, n4);
            if (n5 == -1) return n5;
            this.left -= (long)n5;
            return n5;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void reset() throws IOException {
            synchronized (this) {
                if (!this.in.markSupported()) {
                    throw new IOException("Mark not supported");
                }
                if (this.mark == -1L) {
                    throw new IOException("Mark not set");
                }
                this.in.reset();
                this.left = this.mark;
                return;
            }
        }

        @Override
        public long skip(long l2) throws IOException {
            long l3 = Math.min(l2, this.left);
            long l4 = this.in.skip(l3);
            this.left -= l4;
            return l4;
        }
    }
}

