/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.Preconditions;
import com.google.api.client.util.StreamingContent;
import java.io.IOException;
import java.io.OutputStream;

public class ByteArrayStreamingContent
implements StreamingContent {
    private final byte[] byteArray;
    private final int length;
    private final int offset;

    public ByteArrayStreamingContent(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ByteArrayStreamingContent(byte[] byArray, int n2, int n3) {
        this.byteArray = Preconditions.checkNotNull(byArray);
        boolean bl2 = n2 >= 0 && n3 >= 0 && n2 + n3 <= byArray.length;
        Preconditions.checkArgument(bl2);
        this.offset = n2;
        this.length = n3;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.byteArray, this.offset, this.length);
        outputStream.flush();
    }
}

