/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.ArrayMap;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Types;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;

public final class ArrayValueMap {
    private final Object destination;
    private final Map<Field, ArrayValue> fieldMap;
    private final Map<String, ArrayValue> keyMap = ArrayMap.create();

    public ArrayValueMap(Object object) {
        this.fieldMap = ArrayMap.create();
        this.destination = object;
    }

    public void put(String string2, Class<?> clazz, Object object) {
        ArrayValue arrayValue = this.keyMap.get(string2);
        if (arrayValue == null) {
            arrayValue = new ArrayValue(clazz);
            this.keyMap.put(string2, arrayValue);
        }
        arrayValue.addValue(clazz, object);
    }

    public void put(Field field, Class<?> clazz, Object object) {
        ArrayValue arrayValue = this.fieldMap.get(field);
        if (arrayValue == null) {
            arrayValue = new ArrayValue(clazz);
            this.fieldMap.put(field, arrayValue);
        }
        arrayValue.addValue(clazz, object);
    }

    public void setValues() {
        for (Map.Entry<String, ArrayValue> entry : this.keyMap.entrySet()) {
            ((Map)this.destination).put(entry.getKey(), entry.getValue().toArray());
        }
        for (Map.Entry<Field, ArrayValue> entry : this.fieldMap.entrySet()) {
            FieldInfo.setFieldValue(entry.getKey(), this.destination, entry.getValue().toArray());
        }
    }

    static class ArrayValue {
        final Class<?> componentType;
        final ArrayList<Object> values = new ArrayList();

        ArrayValue(Class<?> clazz) {
            this.componentType = clazz;
        }

        /*
         * Enabled aggressive block sorting
         */
        void addValue(Class<?> clazz, Object object) {
            boolean bl2 = clazz == this.componentType;
            Preconditions.checkArgument(bl2);
            this.values.add(object);
        }

        Object toArray() {
            return Types.toArray(this.values, this.componentType);
        }
    }
}

