/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.Objects;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ArrayMap<K, V>
extends AbstractMap<K, V>
implements Cloneable {
    private Object[] data;
    int size;

    public static <K, V> ArrayMap<K, V> create() {
        return new ArrayMap<K, V>();
    }

    public static <K, V> ArrayMap<K, V> create(int n2) {
        ArrayMap<K, V> arrayMap = ArrayMap.create();
        arrayMap.ensureCapacity(n2);
        return arrayMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getDataIndexOfKey(Object object) {
        int n2 = this.size << 1;
        Object[] objectArray = this.data;
        int n3 = 0;
        while (n3 < n2) {
            Object object2 = objectArray[n3];
            if (object == null ? object2 == null : object.equals(object2)) {
                return n3;
            }
            n3 += 2;
        }
        return -2;
    }

    public static <K, V> ArrayMap<K, V> of(Object ... objectArray) {
        ArrayMap<K, V> arrayMap = ArrayMap.create(1);
        int n2 = objectArray.length;
        if (1 == n2 % 2) {
            throw new IllegalArgumentException("missing value for last key: " + objectArray[n2 - 1]);
        }
        arrayMap.size = objectArray.length / 2;
        Object[] objectArray2 = new Object[n2];
        arrayMap.data = objectArray2;
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        return arrayMap;
    }

    private V removeFromDataIndexOfKey(int n2) {
        int n3 = this.size << 1;
        if (n2 < 0 || n2 >= n3) {
            return null;
        }
        V v2 = this.valueAtDataIndex(n2 + 1);
        Object[] objectArray = this.data;
        int n4 = -2 + (n3 - n2);
        if (n4 != 0) {
            System.arraycopy(objectArray, n2 + 2, objectArray, n2, n4);
        }
        this.size = -1 + this.size;
        this.setData(n3 - 2, null, null);
        return v2;
    }

    private void setData(int n2, K k2, V v2) {
        Object[] objectArray = this.data;
        objectArray[n2] = k2;
        objectArray[n2 + 1] = v2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setDataCapacity(int n2) {
        if (n2 == 0) {
            this.data = null;
            return;
        } else {
            int n3 = this.size;
            Object[] objectArray = this.data;
            if (n3 != 0 && n2 == objectArray.length) return;
            Object[] objectArray2 = new Object[n2];
            this.data = objectArray2;
            if (n3 == 0) return;
            System.arraycopy(objectArray, 0, objectArray2, 0, n3 << 1);
            return;
        }
    }

    private V valueAtDataIndex(int n2) {
        if (n2 < 0) {
            return null;
        }
        return (V)this.data[n2];
    }

    public final void add(K k2, V v2) {
        this.set(this.size, k2, v2);
    }

    @Override
    public void clear() {
        this.size = 0;
        this.data = null;
    }

    @Override
    public ArrayMap<K, V> clone() {
        ArrayMap arrayMap;
        block3: {
            Object[] objectArray;
            try {
                arrayMap = (ArrayMap)super.clone();
                objectArray = this.data;
                if (objectArray == null) break block3;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
            int n2 = objectArray.length;
            Object[] objectArray2 = new Object[n2];
            arrayMap.data = objectArray2;
            System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        }
        return arrayMap;
    }

    @Override
    public final boolean containsKey(Object object) {
        return -2 != this.getDataIndexOfKey(object);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final boolean containsValue(Object object) {
        int n2 = this.size << 1;
        Object[] objectArray = this.data;
        int n3 = 1;
        while (n3 < n2) {
            Object object2 = objectArray[n3];
            if (object == null ? object2 == null : object.equals(object2)) {
                return true;
            }
            n3 += 2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void ensureCapacity(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 << 1;
        Object[] objectArray = this.data;
        int n4 = objectArray == null ? 0 : objectArray.length;
        if (n3 > n4) {
            int n5 = 1 + 3 * (n4 / 2);
            if (n5 % 2 != 0) {
                ++n5;
            }
            if (n5 < n3) {
                n5 = n3;
            }
            this.setDataCapacity(n5);
        }
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public final V get(Object object) {
        return this.valueAtDataIndex(1 + this.getDataIndexOfKey(object));
    }

    public final int getIndexOfKey(K k2) {
        return this.getDataIndexOfKey(k2) >> 1;
    }

    public final K getKey(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            return null;
        }
        return (K)this.data[n2 << 1];
    }

    public final V getValue(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            return null;
        }
        return this.valueAtDataIndex(1 + (n2 << 1));
    }

    @Override
    public final V put(K k2, V v2) {
        int n2 = this.getIndexOfKey(k2);
        if (n2 == -1) {
            n2 = this.size;
        }
        return this.set(n2, k2, v2);
    }

    public final V remove(int n2) {
        return this.removeFromDataIndexOfKey(n2 << 1);
    }

    @Override
    public final V remove(Object object) {
        return this.removeFromDataIndexOfKey(this.getDataIndexOfKey(object));
    }

    public final V set(int n2, V v2) {
        int n3 = this.size;
        if (n2 < 0 || n2 >= n3) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = 1 + (n2 << 1);
        V v3 = this.valueAtDataIndex(n4);
        this.data[n4] = v2;
        return v3;
    }

    public final V set(int n2, K k2, V v2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 + 1;
        this.ensureCapacity(n3);
        int n4 = n2 << 1;
        V v3 = this.valueAtDataIndex(n4 + 1);
        this.setData(n4, k2, v2);
        if (n3 > this.size) {
            this.size = n3;
        }
        return v3;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void trim() {
        this.setDataCapacity(this.size << 1);
    }

    final class Entry
    implements Map.Entry<K, V> {
        private int index;

        Entry(int n2) {
            this.index = n2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean equals(Object object) {
            block5: {
                block4: {
                    if (this == object) break block4;
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    if (!Objects.equal(this.getKey(), entry.getKey()) || !Objects.equal(this.getValue(), entry.getValue())) break block5;
                }
                return true;
            }
            return false;
        }

        @Override
        public K getKey() {
            return ArrayMap.this.getKey(this.index);
        }

        @Override
        public V getValue() {
            return ArrayMap.this.getValue(this.index);
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode() ^ this.getValue().hashCode();
        }

        @Override
        public V setValue(V v2) {
            return ArrayMap.this.set(this.index, v2);
        }
    }

    final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private int nextIndex;
        private boolean removed;

        EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < ArrayMap.this.size;
        }

        @Override
        public Map.Entry<K, V> next() {
            int n2 = this.nextIndex;
            if (n2 == ArrayMap.this.size) {
                throw new NoSuchElementException();
            }
            this.nextIndex = 1 + this.nextIndex;
            return new Entry(n2);
        }

        @Override
        public void remove() {
            int n2 = -1 + this.nextIndex;
            if (this.removed || n2 < 0) {
                throw new IllegalArgumentException();
            }
            ArrayMap.this.remove(n2);
            this.removed = true;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return ArrayMap.this.size;
        }
    }
}

