/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.testing.util;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import java.io.IOException;

@Beta
public class MockBackOff
implements BackOff {
    private long backOffMillis;
    private int maxTries = 10;
    private int numTries;

    public final int getMaxTries() {
        return this.numTries;
    }

    public final int getNumberOfTries() {
        return this.numTries;
    }

    @Override
    public long nextBackOffMillis() throws IOException {
        if (this.numTries >= this.maxTries || this.backOffMillis == -1L) {
            return -1L;
        }
        this.numTries = 1 + this.numTries;
        return this.backOffMillis;
    }

    @Override
    public void reset() throws IOException {
        this.numTries = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public MockBackOff setBackOffMillis(long l2) {
        boolean bl2 = l2 == -1L || l2 >= 0L;
        Preconditions.checkArgument(bl2);
        this.backOffMillis = l2;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public MockBackOff setMaxTries(int n2) {
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2);
        this.maxTries = n2;
        return this;
    }
}

