/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.testing.http.javanet;

import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

@Beta
public class MockHttpURLConnection
extends HttpURLConnection {
    public static final byte[] ERROR_BUF;
    public static final byte[] INPUT_BUF;
    private boolean doOutputCalled;
    private InputStream errorStream;
    private InputStream inputStream;
    private OutputStream outputStream = new ByteArrayOutputStream(0);

    static {
        INPUT_BUF = new byte[1];
        ERROR_BUF = new byte[5];
    }

    public MockHttpURLConnection(URL uRL) {
        super(uRL);
        this.inputStream = new ByteArrayInputStream(INPUT_BUF);
        this.errorStream = new ByteArrayInputStream(ERROR_BUF);
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public void disconnect() {
    }

    public final boolean doOutputCalled() {
        return this.doOutputCalled;
    }

    @Override
    public InputStream getErrorStream() {
        return this.errorStream;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.responseCode < 400) {
            return this.inputStream;
        }
        throw new IOException();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        return super.getOutputStream();
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.responseCode;
    }

    @Override
    public void setDoOutput(boolean bl2) {
        this.doOutputCalled = true;
    }

    public MockHttpURLConnection setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public MockHttpURLConnection setResponseCode(int n2) {
        boolean bl2 = n2 >= -1;
        Preconditions.checkArgument(bl2);
        this.responseCode = n2;
        return this;
    }

    @Override
    public boolean usingProxy() {
        return false;
    }
}

