/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.testing.http;

import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Charsets;
import com.google.api.client.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

@Beta
public class MockLowLevelHttpRequest
extends LowLevelHttpRequest {
    private final Map<String, List<String>> headersMap = new HashMap<String, List<String>>();
    private MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
    private String url;

    public MockLowLevelHttpRequest() {
    }

    public MockLowLevelHttpRequest(String string2) {
        this.url = string2;
    }

    @Override
    public void addHeader(String string2, String string3) throws IOException {
        String string4 = string2.toLowerCase();
        List<String> list = this.headersMap.get(string4);
        if (list == null) {
            list = new ArrayList<String>();
            this.headersMap.put(string4, list);
        }
        list.add(string3);
    }

    @Override
    public LowLevelHttpResponse execute() throws IOException {
        return this.response;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getContentAsString() throws IOException {
        Charset charset;
        String string2;
        HttpMediaType httpMediaType;
        if (this.getStreamingContent() == null) {
            return "";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.getStreamingContent().writeTo(byteArrayOutputStream);
        String string3 = this.getContentEncoding();
        if (string3 != null && string3.contains("gzip")) {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtils.copy(gZIPInputStream, byteArrayOutputStream);
        }
        if ((httpMediaType = (string2 = this.getContentType()) != null ? new HttpMediaType(string2) : null) != null && httpMediaType.getCharsetParameter() != null) {
            charset = httpMediaType.getCharsetParameter();
            return byteArrayOutputStream.toString(charset.name());
        }
        charset = Charsets.ISO_8859_1;
        return byteArrayOutputStream.toString(charset.name());
    }

    public String getFirstHeaderValue(String string2) {
        List<String> list = this.headersMap.get(string2.toLowerCase());
        if (list == null) {
            return null;
        }
        return list.get(0);
    }

    public List<String> getHeaderValues(String string2) {
        List<String> list = this.headersMap.get(string2.toLowerCase());
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headersMap);
    }

    public MockLowLevelHttpResponse getResponse() {
        return this.response;
    }

    public String getUrl() {
        return this.url;
    }

    public MockLowLevelHttpRequest setResponse(MockLowLevelHttpResponse mockLowLevelHttpResponse) {
        this.response = mockLowLevelHttpResponse;
        return this;
    }

    public MockLowLevelHttpRequest setUrl(String string2) {
        this.url = string2;
        return this;
    }
}

