/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.testing.http;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

@Beta
public class MockHttpTransport
extends HttpTransport {
    private MockLowLevelHttpRequest lowLevelHttpRequest;
    private MockLowLevelHttpResponse lowLevelHttpResponse;
    private Set<String> supportedMethods;

    public MockHttpTransport() {
    }

    protected MockHttpTransport(Builder builder) {
        this.supportedMethods = builder.supportedMethods;
        this.lowLevelHttpRequest = builder.lowLevelHttpRequest;
        this.lowLevelHttpResponse = builder.lowLevelHttpResponse;
    }

    @Deprecated
    public static Builder builder() {
        return new Builder();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public LowLevelHttpRequest buildRequest(String string2, String string3) throws IOException {
        Preconditions.checkArgument(this.supportsMethod(string2), "HTTP method %s not supported", string2);
        if (this.lowLevelHttpRequest != null) {
            return this.lowLevelHttpRequest;
        }
        MockLowLevelHttpRequest mockLowLevelHttpRequest = new MockLowLevelHttpRequest(string3);
        if (this.lowLevelHttpResponse == null) return mockLowLevelHttpRequest;
        mockLowLevelHttpRequest.setResponse(this.lowLevelHttpResponse);
        return mockLowLevelHttpRequest;
    }

    public final MockLowLevelHttpRequest getLowLevelHttpRequest() {
        return this.lowLevelHttpRequest;
    }

    public final Set<String> getSupportedMethods() {
        if (this.supportedMethods == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.supportedMethods);
    }

    @Override
    public boolean supportsMethod(String string2) throws IOException {
        return this.supportedMethods == null || this.supportedMethods.contains(string2);
    }

    @Beta
    public static class Builder {
        MockLowLevelHttpRequest lowLevelHttpRequest;
        MockLowLevelHttpResponse lowLevelHttpResponse;
        Set<String> supportedMethods;

        public MockHttpTransport build() {
            return new MockHttpTransport(this);
        }

        public final MockLowLevelHttpRequest getLowLevelHttpRequest() {
            return this.lowLevelHttpRequest;
        }

        MockLowLevelHttpResponse getLowLevelHttpResponse() {
            return this.lowLevelHttpResponse;
        }

        public final Set<String> getSupportedMethods() {
            return this.supportedMethods;
        }

        /*
         * Enabled aggressive block sorting
         */
        public final Builder setLowLevelHttpRequest(MockLowLevelHttpRequest mockLowLevelHttpRequest) {
            boolean bl2 = this.lowLevelHttpResponse == null;
            Preconditions.checkState(bl2, "Cannnot set a low level HTTP request when a low level HTTP response has been set.");
            this.lowLevelHttpRequest = mockLowLevelHttpRequest;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public final Builder setLowLevelHttpResponse(MockLowLevelHttpResponse mockLowLevelHttpResponse) {
            boolean bl2 = this.lowLevelHttpRequest == null;
            Preconditions.checkState(bl2, "Cannot set a low level HTTP response when a low level HTTP request has been set.");
            this.lowLevelHttpResponse = mockLowLevelHttpResponse;
            return this;
        }

        public final Builder setSupportedMethods(Set<String> set) {
            this.supportedMethods = set;
            return this;
        }
    }
}

