/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.testing.http;

import com.google.api.client.http.HttpContent;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.io.OutputStream;

@Beta
public class MockHttpContent
implements HttpContent {
    private byte[] content = new byte[0];
    private long length = -1L;
    private String type;

    public final byte[] getContent() {
        return this.content;
    }

    @Override
    public long getLength() throws IOException {
        return this.length;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean retrySupported() {
        return true;
    }

    public MockHttpContent setContent(byte[] byArray) {
        this.content = Preconditions.checkNotNull(byArray);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public MockHttpContent setLength(long l2) {
        boolean bl2 = l2 >= -1L;
        Preconditions.checkArgument(bl2);
        this.length = l2;
        return this;
    }

    public MockHttpContent setType(String string2) {
        this.type = string2;
        return this;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.content);
        outputStream.flush();
    }
}

