/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.repackaged.org.apache.commons.codec.binary;

import java.io.UnsupportedEncodingException;

public class StringUtils {
    public static byte[] getBytesIso8859_1(String string2) {
        return StringUtils.getBytesUnchecked(string2, "ISO-8859-1");
    }

    public static byte[] getBytesUnchecked(String string2, String string3) {
        if (string2 == null) {
            return null;
        }
        try {
            byte[] byArray = string2.getBytes(string3);
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw StringUtils.newIllegalStateException(string3, unsupportedEncodingException);
        }
    }

    public static byte[] getBytesUsAscii(String string2) {
        return StringUtils.getBytesUnchecked(string2, "US-ASCII");
    }

    public static byte[] getBytesUtf16(String string2) {
        return StringUtils.getBytesUnchecked(string2, "UTF-16");
    }

    public static byte[] getBytesUtf16Be(String string2) {
        return StringUtils.getBytesUnchecked(string2, "UTF-16BE");
    }

    public static byte[] getBytesUtf16Le(String string2) {
        return StringUtils.getBytesUnchecked(string2, "UTF-16LE");
    }

    public static byte[] getBytesUtf8(String string2) {
        return StringUtils.getBytesUnchecked(string2, "UTF-8");
    }

    private static IllegalStateException newIllegalStateException(String string2, UnsupportedEncodingException unsupportedEncodingException) {
        return new IllegalStateException(string2 + ": " + unsupportedEncodingException);
    }

    public static String newString(byte[] byArray, String string2) {
        if (byArray == null) {
            return null;
        }
        try {
            String string3 = new String(byArray, string2);
            return string3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw StringUtils.newIllegalStateException(string2, unsupportedEncodingException);
        }
    }

    public static String newStringIso8859_1(byte[] byArray) {
        return StringUtils.newString(byArray, "ISO-8859-1");
    }

    public static String newStringUsAscii(byte[] byArray) {
        return StringUtils.newString(byArray, "US-ASCII");
    }

    public static String newStringUtf16(byte[] byArray) {
        return StringUtils.newString(byArray, "UTF-16");
    }

    public static String newStringUtf16Be(byte[] byArray) {
        return StringUtils.newString(byArray, "UTF-16BE");
    }

    public static String newStringUtf16Le(byte[] byArray) {
        return StringUtils.newString(byArray, "UTF-16LE");
    }

    public static String newStringUtf8(byte[] byArray) {
        return StringUtils.newString(byArray, "UTF-8");
    }
}

