/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.repackaged.org.apache.commons.codec.binary;

import com.google.api.client.repackaged.org.apache.commons.codec.BinaryDecoder;
import com.google.api.client.repackaged.org.apache.commons.codec.BinaryEncoder;
import com.google.api.client.repackaged.org.apache.commons.codec.DecoderException;
import com.google.api.client.repackaged.org.apache.commons.codec.EncoderException;
import com.google.api.client.repackaged.org.apache.commons.codec.binary.StringUtils;

public abstract class BaseNCodec
implements BinaryEncoder,
BinaryDecoder {
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    protected static final int MASK_8BITS = 255;
    public static final int MIME_CHUNK_SIZE = 76;
    protected static final byte PAD_DEFAULT = 61;
    public static final int PEM_CHUNK_SIZE = 64;
    protected final byte PAD = (byte)61;
    protected byte[] buffer;
    private final int chunkSeparatorLength;
    protected int currentLinePos;
    private final int encodedBlockSize;
    protected boolean eof;
    protected final int lineLength;
    protected int modulus;
    protected int pos;
    private int readPos;
    private final int unencodedBlockSize;

    /*
     * Enabled aggressive block sorting
     */
    protected BaseNCodec(int n2, int n3, int n4, int n5) {
        this.unencodedBlockSize = n2;
        this.encodedBlockSize = n3;
        int n6 = n4 > 0 && n5 > 0 ? n3 * (n4 / n3) : 0;
        this.lineLength = n6;
        this.chunkSeparatorLength = n5;
    }

    protected static boolean isWhiteSpace(byte by2) {
        switch (by2) {
            default: {
                return false;
            }
            case 9: 
            case 10: 
            case 13: 
            case 32: 
        }
        return true;
    }

    private void reset() {
        this.buffer = null;
        this.pos = 0;
        this.readPos = 0;
        this.currentLinePos = 0;
        this.modulus = 0;
        this.eof = false;
    }

    private void resizeBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[this.getDefaultBufferSize()];
            this.pos = 0;
            this.readPos = 0;
            return;
        }
        byte[] byArray = new byte[2 * this.buffer.length];
        System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
        this.buffer = byArray;
    }

    int available() {
        if (this.buffer != null) {
            return this.pos - this.readPos;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean containsAlphabetOrPad(byte[] byArray) {
        if (byArray != null) {
            for (byte by2 : byArray) {
                if (61 != by2 && !this.isInAlphabet(by2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object decode(Object object) throws DecoderException {
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        if (object instanceof String) {
            return this.decode((String)object);
        }
        throw new DecoderException("Parameter supplied to Base-N decode is not a byte[] or a String");
    }

    abstract void decode(byte[] var1, int var2, int var3);

    public byte[] decode(String string2) {
        return this.decode(StringUtils.getBytesUtf8(string2));
    }

    @Override
    public byte[] decode(byte[] byArray) {
        this.reset();
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        this.decode(byArray, 0, byArray.length);
        this.decode(byArray, 0, -1);
        byte[] byArray2 = new byte[this.pos];
        this.readResults(byArray2, 0, byArray2.length);
        return byArray2;
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof byte[])) {
            throw new EncoderException("Parameter supplied to Base-N encode is not a byte[]");
        }
        return this.encode((byte[])object);
    }

    abstract void encode(byte[] var1, int var2, int var3);

    @Override
    public byte[] encode(byte[] byArray) {
        this.reset();
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        this.encode(byArray, 0, byArray.length);
        this.encode(byArray, 0, -1);
        byte[] byArray2 = new byte[this.pos - this.readPos];
        this.readResults(byArray2, 0, byArray2.length);
        return byArray2;
    }

    public String encodeAsString(byte[] byArray) {
        return StringUtils.newStringUtf8(this.encode(byArray));
    }

    public String encodeToString(byte[] byArray) {
        return StringUtils.newStringUtf8(this.encode(byArray));
    }

    protected void ensureBufferSize(int n2) {
        if (this.buffer == null || this.buffer.length < n2 + this.pos) {
            this.resizeBuffer();
        }
    }

    protected int getDefaultBufferSize() {
        return 8192;
    }

    public long getEncodedLength(byte[] byArray) {
        long l2 = (long)((-1 + (byArray.length + this.unencodedBlockSize)) / this.unencodedBlockSize) * (long)this.encodedBlockSize;
        if (this.lineLength > 0) {
            l2 += (l2 + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.chunkSeparatorLength;
        }
        return l2;
    }

    boolean hasData() {
        return this.buffer != null;
    }

    protected abstract boolean isInAlphabet(byte var1);

    public boolean isInAlphabet(String string2) {
        return this.isInAlphabet(StringUtils.getBytesUtf8(string2), true);
    }

    public boolean isInAlphabet(byte[] byArray, boolean bl2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (this.isInAlphabet(byArray[i2]) || bl2 && (byArray[i2] == 61 || BaseNCodec.isWhiteSpace(byArray[i2]))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int readResults(byte[] byArray, int n2, int n3) {
        if (this.buffer != null) {
            int n4 = Math.min(this.available(), n3);
            System.arraycopy(this.buffer, this.readPos, byArray, n2, n4);
            this.readPos = n4 + this.readPos;
            if (this.readPos < this.pos) return n4;
            this.buffer = null;
            return n4;
        }
        if (!this.eof) return 0;
        return -1;
    }
}

