/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.repackaged.org.apache.commons.codec.binary;

import com.google.api.client.repackaged.org.apache.commons.codec.binary.BaseNCodec;
import com.google.api.client.repackaged.org.apache.commons.codec.binary.StringUtils;
import java.math.BigInteger;

public class Base64
extends BaseNCodec {
    private static final int BITS_PER_ENCODED_BYTE = 6;
    private static final int BYTES_PER_ENCODED_BLOCK = 4;
    private static final int BYTES_PER_UNENCODED_BLOCK = 3;
    static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private static final byte[] DECODE_TABLE;
    private static final int MASK_6BITS = 63;
    private static final byte[] STANDARD_ENCODE_TABLE;
    private static final byte[] URL_SAFE_ENCODE_TABLE;
    private int bitWorkArea;
    private final int decodeSize;
    private final byte[] decodeTable;
    private final int encodeSize;
    private final byte[] encodeTable;
    private final byte[] lineSeparator;

    static {
        STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
        DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    }

    public Base64() {
        this(0);
    }

    public Base64(int n2) {
        this(n2, CHUNK_SEPARATOR);
    }

    public Base64(int n2, byte[] byArray) {
        this(n2, byArray, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Base64(int n2, byte[] byArray, boolean bl2) {
        int n3 = byArray == null ? 0 : byArray.length;
        super(3, 4, n2, n3);
        this.decodeTable = DECODE_TABLE;
        if (byArray != null) {
            if (this.containsAlphabetOrPad(byArray)) {
                String string2 = StringUtils.newStringUtf8(byArray);
                throw new IllegalArgumentException("lineSeparator must not contain base64 characters: [" + string2 + "]");
            }
            if (n2 > 0) {
                this.encodeSize = 4 + byArray.length;
                this.lineSeparator = new byte[byArray.length];
                System.arraycopy(byArray, 0, this.lineSeparator, 0, byArray.length);
            } else {
                this.encodeSize = 4;
                this.lineSeparator = null;
            }
        } else {
            this.encodeSize = 4;
            this.lineSeparator = null;
        }
        this.decodeSize = -1 + this.encodeSize;
        byte[] byArray2 = bl2 ? URL_SAFE_ENCODE_TABLE : STANDARD_ENCODE_TABLE;
        this.encodeTable = byArray2;
    }

    public Base64(boolean bl2) {
        this(76, CHUNK_SEPARATOR, bl2);
    }

    public static byte[] decodeBase64(String string2) {
        return new Base64().decode(string2);
    }

    public static byte[] decodeBase64(byte[] byArray) {
        return new Base64().decode(byArray);
    }

    public static BigInteger decodeInteger(byte[] byArray) {
        return new BigInteger(1, Base64.decodeBase64(byArray));
    }

    public static byte[] encodeBase64(byte[] byArray) {
        return Base64.encodeBase64(byArray, false);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl2) {
        return Base64.encodeBase64(byArray, bl2, false);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl2, boolean bl3) {
        return Base64.encodeBase64(byArray, bl2, bl3, Integer.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte[] encodeBase64(byte[] byArray, boolean bl2, boolean bl3, int n2) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        Base64 base64 = bl2 ? new Base64(bl3) : new Base64(0, CHUNK_SEPARATOR, bl3);
        long l2 = base64.getEncodedLength(byArray);
        if (l2 > (long)n2) {
            throw new IllegalArgumentException("Input array too big, the output array would be bigger (" + l2 + ") than the specified maximum size of " + n2);
        }
        return base64.encode(byArray);
    }

    public static byte[] encodeBase64Chunked(byte[] byArray) {
        return Base64.encodeBase64(byArray, true);
    }

    public static String encodeBase64String(byte[] byArray) {
        return StringUtils.newStringUtf8(Base64.encodeBase64(byArray, false));
    }

    public static byte[] encodeBase64URLSafe(byte[] byArray) {
        return Base64.encodeBase64(byArray, false, true);
    }

    public static String encodeBase64URLSafeString(byte[] byArray) {
        return StringUtils.newStringUtf8(Base64.encodeBase64(byArray, false, true));
    }

    public static byte[] encodeInteger(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new NullPointerException("encodeInteger called with null parameter");
        }
        return Base64.encodeBase64(Base64.toIntegerBytes(bigInteger), false);
    }

    public static boolean isArrayByteBase64(byte[] byArray) {
        return Base64.isBase64(byArray);
    }

    public static boolean isBase64(byte by2) {
        return by2 == 61 || by2 >= 0 && by2 < DECODE_TABLE.length && DECODE_TABLE[by2] != -1;
    }

    public static boolean isBase64(String string2) {
        return Base64.isBase64(StringUtils.getBytesUtf8(string2));
    }

    public static boolean isBase64(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (Base64.isBase64(byArray[i2]) || Base64.isWhiteSpace(byArray[i2])) continue;
            return false;
        }
        return true;
    }

    static byte[] toIntegerBytes(BigInteger bigInteger) {
        int n2 = 7 + bigInteger.bitLength() >> 3 << 3;
        byte[] byArray = bigInteger.toByteArray();
        if (bigInteger.bitLength() % 8 != 0 && 1 + bigInteger.bitLength() / 8 == n2 / 8) {
            return byArray;
        }
        int n3 = byArray.length;
        int n4 = bigInteger.bitLength() % 8;
        int n5 = 0;
        if (n4 == 0) {
            n5 = 1;
            --n3;
        }
        int n6 = n2 / 8 - n3;
        byte[] byArray2 = new byte[n2 / 8];
        System.arraycopy(byArray, n5, byArray2, n6, n3);
        return byArray2;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    @Override
    void decode(byte[] byArray, int n2, int n3) {
        block13: {
            block12: {
                if (this.eof) break block12;
                if (n3 < 0) {
                    this.eof = true;
                }
                int n4 = n2;
                for (int i2 = 0; i2 < n3; ++i2) {
                    byte by2;
                    this.ensureBufferSize(this.decodeSize);
                    int n5 = n4 + 1;
                    byte by3 = byArray[n4];
                    if (by3 == 61) {
                        this.eof = true;
                        break;
                    }
                    if (by3 >= 0 && by3 < DECODE_TABLE.length && (by2 = DECODE_TABLE[by3]) >= 0) {
                        this.modulus = (1 + this.modulus) % 4;
                        this.bitWorkArea = by2 + (this.bitWorkArea << 6);
                        if (this.modulus == 0) {
                            byte[] byArray2 = this.buffer;
                            int n6 = this.pos;
                            this.pos = n6 + 1;
                            byArray2[n6] = (byte)(0xFF & this.bitWorkArea >> 16);
                            byte[] byArray3 = this.buffer;
                            int n7 = this.pos;
                            this.pos = n7 + 1;
                            byArray3[n7] = (byte)(0xFF & this.bitWorkArea >> 8);
                            byte[] byArray4 = this.buffer;
                            int n8 = this.pos;
                            this.pos = n8 + 1;
                            byArray4[n8] = (byte)(0xFF & this.bitWorkArea);
                        }
                    }
                    n4 = n5;
                }
                if (this.eof && this.modulus != 0) break block13;
            }
            return;
        }
        this.ensureBufferSize(this.decodeSize);
        switch (this.modulus) {
            default: {
                return;
            }
            case 2: {
                this.bitWorkArea >>= 4;
                byte[] byArray5 = this.buffer;
                int n9 = this.pos;
                this.pos = n9 + 1;
                byArray5[n9] = (byte)(0xFF & this.bitWorkArea);
                return;
            }
            case 3: 
        }
        this.bitWorkArea >>= 2;
        byte[] byArray6 = this.buffer;
        int n10 = this.pos;
        this.pos = n10 + 1;
        byArray6[n10] = (byte)(0xFF & this.bitWorkArea >> 8);
        byte[] byArray7 = this.buffer;
        int n11 = this.pos;
        this.pos = n11 + 1;
        byArray7[n11] = (byte)(0xFF & this.bitWorkArea);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void encode(byte[] byArray, int n2, int n3) {
        block14: {
            block15: {
                block13: {
                    if (this.eof) break block13;
                    if (n3 >= 0) break block14;
                    this.eof = true;
                    if (this.modulus == 0 && this.lineLength == 0) break block13;
                    this.ensureBufferSize(this.encodeSize);
                    int n4 = this.pos;
                    switch (this.modulus) {
                        case 1: {
                            byte[] byArray2 = this.buffer;
                            int n5 = this.pos;
                            this.pos = n5 + 1;
                            byArray2[n5] = this.encodeTable[0x3F & this.bitWorkArea >> 2];
                            byte[] byArray3 = this.buffer;
                            int n6 = this.pos;
                            this.pos = n6 + 1;
                            byArray3[n6] = this.encodeTable[0x3F & this.bitWorkArea << 4];
                            if (this.encodeTable == STANDARD_ENCODE_TABLE) {
                                byte[] byArray4 = this.buffer;
                                int n7 = this.pos;
                                this.pos = n7 + 1;
                                byArray4[n7] = 61;
                                byte[] byArray5 = this.buffer;
                                int n8 = this.pos;
                                this.pos = n8 + 1;
                                byArray5[n8] = 61;
                            }
                        }
                        default: {
                            break;
                        }
                        case 2: {
                            byte[] byArray6 = this.buffer;
                            int n9 = this.pos;
                            this.pos = n9 + 1;
                            byArray6[n9] = this.encodeTable[0x3F & this.bitWorkArea >> 10];
                            byte[] byArray7 = this.buffer;
                            int n10 = this.pos;
                            this.pos = n10 + 1;
                            byArray7[n10] = this.encodeTable[0x3F & this.bitWorkArea >> 4];
                            byte[] byArray8 = this.buffer;
                            int n11 = this.pos;
                            this.pos = n11 + 1;
                            byArray8[n11] = this.encodeTable[0x3F & this.bitWorkArea << 2];
                            if (this.encodeTable != STANDARD_ENCODE_TABLE) break;
                            byte[] byArray9 = this.buffer;
                            int n12 = this.pos;
                            this.pos = n12 + 1;
                            byArray9[n12] = 61;
                        }
                    }
                    this.currentLinePos += this.pos - n4;
                    if (this.lineLength > 0 && this.currentLinePos > 0) break block15;
                }
                return;
            }
            System.arraycopy(this.lineSeparator, 0, this.buffer, this.pos, this.lineSeparator.length);
            this.pos += this.lineSeparator.length;
            return;
        }
        int n13 = 0;
        int n14 = n2;
        while (true) {
            if (n13 >= n3) {
                return;
            }
            this.ensureBufferSize(this.encodeSize);
            this.modulus = (1 + this.modulus) % 3;
            int n15 = n14 + 1;
            int n16 = byArray[n14];
            if (n16 < 0) {
                n16 += 256;
            }
            this.bitWorkArea = n16 + (this.bitWorkArea << 8);
            if (this.modulus == 0) {
                byte[] byArray10 = this.buffer;
                int n17 = this.pos;
                this.pos = n17 + 1;
                byArray10[n17] = this.encodeTable[0x3F & this.bitWorkArea >> 18];
                byte[] byArray11 = this.buffer;
                int n18 = this.pos;
                this.pos = n18 + 1;
                byArray11[n18] = this.encodeTable[0x3F & this.bitWorkArea >> 12];
                byte[] byArray12 = this.buffer;
                int n19 = this.pos;
                this.pos = n19 + 1;
                byArray12[n19] = this.encodeTable[0x3F & this.bitWorkArea >> 6];
                byte[] byArray13 = this.buffer;
                int n20 = this.pos;
                this.pos = n20 + 1;
                byArray13[n20] = this.encodeTable[0x3F & this.bitWorkArea];
                this.currentLinePos = 4 + this.currentLinePos;
                if (this.lineLength > 0 && this.lineLength <= this.currentLinePos) {
                    System.arraycopy(this.lineSeparator, 0, this.buffer, this.pos, this.lineSeparator.length);
                    this.pos += this.lineSeparator.length;
                    this.currentLinePos = 0;
                }
            }
            ++n13;
            n14 = n15;
        }
    }

    @Override
    protected boolean isInAlphabet(byte by2) {
        return by2 >= 0 && by2 < this.decodeTable.length && this.decodeTable[by2] != -1;
    }

    public boolean isUrlSafe() {
        return this.encodeTable == URL_SAFE_ENCODE_TABLE;
    }
}

