/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.repackaged.com.google.common.base;

import com.google.api.client.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.api.client.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import javax.annotation.Nullable;

@GwtCompatible
public final class Strings {
    private Strings() {
    }

    public static String commonPrefix(CharSequence charSequence, CharSequence charSequence2) {
        int n2;
        Preconditions.checkNotNull(charSequence);
        Preconditions.checkNotNull(charSequence2);
        int n3 = Math.min(charSequence.length(), charSequence2.length());
        for (n2 = 0; n2 < n3 && charSequence.charAt(n2) == charSequence2.charAt(n2); ++n2) {
        }
        if (Strings.validSurrogatePairAt(charSequence, n2 - 1) || Strings.validSurrogatePairAt(charSequence2, n2 - 1)) {
            --n2;
        }
        return ((Object)charSequence.subSequence(0, n2)).toString();
    }

    public static String commonSuffix(CharSequence charSequence, CharSequence charSequence2) {
        int n2;
        Preconditions.checkNotNull(charSequence);
        Preconditions.checkNotNull(charSequence2);
        int n3 = Math.min(charSequence.length(), charSequence2.length());
        for (n2 = 0; n2 < n3 && charSequence.charAt(-1 + (charSequence.length() - n2)) == charSequence2.charAt(-1 + (charSequence2.length() - n2)); ++n2) {
        }
        if (Strings.validSurrogatePairAt(charSequence, -1 + (charSequence.length() - n2)) || Strings.validSurrogatePairAt(charSequence2, -1 + (charSequence2.length() - n2))) {
            --n2;
        }
        return ((Object)charSequence.subSequence(charSequence.length() - n2, charSequence.length())).toString();
    }

    @Nullable
    public static String emptyToNull(@Nullable String string2) {
        if (Strings.isNullOrEmpty(string2)) {
            string2 = null;
        }
        return string2;
    }

    public static boolean isNullOrEmpty(@Nullable String string2) {
        return string2 == null || string2.length() == 0;
    }

    public static String nullToEmpty(@Nullable String string2) {
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static String padEnd(String string2, int n2, char c2) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= n2) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append(string2);
        for (int i2 = string2.length(); i2 < n2; ++i2) {
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String padStart(String string2, int n2, char c2) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= n2) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = string2.length(); i2 < n2; ++i2) {
            stringBuilder.append(c2);
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String repeat(String string2, int n2) {
        Preconditions.checkNotNull(string2);
        if (n2 <= 1) {
            boolean bl2 = n2 >= 0;
            Object[] objectArray = new Object[]{n2};
            Preconditions.checkArgument(bl2, "invalid count: %s", objectArray);
            if (n2 != 0) return string2;
            return "";
        }
        int n3 = string2.length();
        long l2 = (long)n3 * (long)n2;
        int n4 = (int)l2;
        if ((long)n4 != l2) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + String.valueOf(l2));
        }
        char[] cArray = new char[n4];
        string2.getChars(0, n3, cArray, 0);
        int n5 = n3;
        while (true) {
            if (n5 >= n4 - n5) {
                System.arraycopy(cArray, 0, cArray, n5, n4 - n5);
                return new String(cArray);
            }
            System.arraycopy(cArray, 0, cArray, n5, n5);
            n5 <<= 1;
        }
    }

    @VisibleForTesting
    static boolean validSurrogatePairAt(CharSequence charSequence, int n2) {
        return n2 >= 0 && n2 <= -2 + charSequence.length() && Character.isHighSurrogate(charSequence.charAt(n2)) && Character.isLowSurrogate(charSequence.charAt(n2 + 1));
    }
}

