/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.repackaged.com.google.common.base;

import com.google.api.client.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.api.client.repackaged.com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;

@GwtCompatible
public final class Preconditions {
    private Preconditions() {
    }

    private static String badElementIndex(int n2, int n3, String string2) {
        if (n2 < 0) {
            Object[] objectArray = new Object[]{string2, n2};
            return Preconditions.format("%s (%s) must not be negative", objectArray);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("negative size: " + n3);
        }
        Object[] objectArray = new Object[]{string2, n2, n3};
        return Preconditions.format("%s (%s) must be less than size (%s)", objectArray);
    }

    private static String badPositionIndex(int n2, int n3, String string2) {
        if (n2 < 0) {
            Object[] objectArray = new Object[]{string2, n2};
            return Preconditions.format("%s (%s) must not be negative", objectArray);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("negative size: " + n3);
        }
        Object[] objectArray = new Object[]{string2, n2, n3};
        return Preconditions.format("%s (%s) must not be greater than size (%s)", objectArray);
    }

    private static String badPositionIndexes(int n2, int n3, int n4) {
        if (n2 < 0 || n2 > n4) {
            return Preconditions.badPositionIndex(n2, n4, "start index");
        }
        if (n3 < 0 || n3 > n4) {
            return Preconditions.badPositionIndex(n3, n4, "end index");
        }
        Object[] objectArray = new Object[]{n3, n2};
        return Preconditions.format("end index (%s) must not be less than start index (%s)", objectArray);
    }

    public static void checkArgument(boolean bl2) {
        if (!bl2) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean bl2, @Nullable Object object) {
        if (!bl2) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string2, Object ... objectArray) {
        if (!bl2) {
            throw new IllegalArgumentException(Preconditions.format(string2, objectArray));
        }
    }

    public static int checkElementIndex(int n2, int n3) {
        return Preconditions.checkElementIndex(n2, n3, "index");
    }

    public static int checkElementIndex(int n2, int n3, @Nullable String string2) {
        if (n2 < 0 || n2 >= n3) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(n2, n3, string2));
        }
        return n2;
    }

    public static <T> T checkNotNull(T t2) {
        if (t2 == null) {
            throw new NullPointerException();
        }
        return t2;
    }

    public static <T> T checkNotNull(T t2, @Nullable Object object) {
        if (t2 == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t2;
    }

    public static <T> T checkNotNull(T t2, @Nullable String string2, Object ... objectArray) {
        if (t2 == null) {
            throw new NullPointerException(Preconditions.format(string2, objectArray));
        }
        return t2;
    }

    public static int checkPositionIndex(int n2, int n3) {
        return Preconditions.checkPositionIndex(n2, n3, "index");
    }

    public static int checkPositionIndex(int n2, int n3, @Nullable String string2) {
        if (n2 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(n2, n3, string2));
        }
        return n2;
    }

    public static void checkPositionIndexes(int n2, int n3, int n4) {
        if (n2 < 0 || n3 < n2 || n3 > n4) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(n2, n3, n4));
        }
    }

    public static void checkState(boolean bl2) {
        if (!bl2) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean bl2, @Nullable Object object) {
        if (!bl2) {
            throw new IllegalStateException(String.valueOf(object));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string2, Object ... objectArray) {
        if (!bl2) {
            throw new IllegalStateException(Preconditions.format(string2, objectArray));
        }
    }

    @VisibleForTesting
    static String format(String string2, Object ... objectArray) {
        StringBuilder stringBuilder;
        block3: {
            String string3 = String.valueOf(string2);
            stringBuilder = new StringBuilder(string3.length() + 16 * objectArray.length);
            int n2 = 0;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 >= objectArray.length || (n4 = string3.indexOf("%s", n2)) == -1) {
                    stringBuilder.append(string3.substring(n2));
                    if (n3 >= objectArray.length) break block3;
                    stringBuilder.append(" [");
                    int n5 = n3 + 1;
                    stringBuilder.append(objectArray[n3]);
                    int n6 = n5;
                    while (n6 < objectArray.length) {
                        stringBuilder.append(", ");
                        int n7 = n6 + 1;
                        stringBuilder.append(objectArray[n6]);
                        n6 = n7;
                    }
                    break;
                }
                stringBuilder.append(string3.substring(n2, n4));
                int n8 = n3 + 1;
                stringBuilder.append(objectArray[n3]);
                n2 = n4 + 2;
                n3 = n8;
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }
}

