/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.repackaged.com.google.common.base;

import com.google.api.client.repackaged.com.google.common.annotations.Beta;
import com.google.api.client.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

@GwtCompatible
public final class Objects {
    private Objects() {
    }

    public static boolean equal(@Nullable Object object, @Nullable Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static <T> T firstNonNull(@Nullable T t2, @Nullable T t3) {
        if (t2 != null) {
            return t2;
        }
        return Preconditions.checkNotNull(t3);
    }

    public static int hashCode(Object ... objectArray) {
        return Arrays.hashCode(objectArray);
    }

    private static String simpleName(Class<?> clazz) {
        String string2 = clazz.getName().replaceAll("\\$[0-9]+", "\\$");
        int n2 = string2.lastIndexOf(36);
        if (n2 == -1) {
            n2 = string2.lastIndexOf(46);
        }
        return string2.substring(n2 + 1);
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(Objects.simpleName(clazz));
    }

    public static ToStringHelper toStringHelper(Object object) {
        return new ToStringHelper(Objects.simpleName(object.getClass()));
    }

    public static ToStringHelper toStringHelper(String string2) {
        return new ToStringHelper(string2);
    }

    public static final class ToStringHelper {
        private final String className;
        private boolean omitNullValues = false;
        private final List<ValueHolder> valueHolders = new LinkedList<ValueHolder>();

        private ToStringHelper(String string2) {
            this.className = Preconditions.checkNotNull(string2);
        }

        private ValueHolder addHolder() {
            ValueHolder valueHolder = new ValueHolder();
            this.valueHolders.add(valueHolder);
            return valueHolder;
        }

        /*
         * Enabled aggressive block sorting
         */
        private ValueHolder addHolder(@Nullable Object object) {
            ValueHolder valueHolder = this.addHolder();
            boolean bl2 = object == null;
            valueHolder.isNull = bl2;
            return valueHolder;
        }

        private StringBuilder checkNameAndAppend(String string2) {
            Preconditions.checkNotNull(string2);
            return this.addHolder().builder.append(string2).append('=');
        }

        public ToStringHelper add(String string2, char c2) {
            this.checkNameAndAppend(string2).append(c2);
            return this;
        }

        public ToStringHelper add(String string2, double d2) {
            this.checkNameAndAppend(string2).append(d2);
            return this;
        }

        public ToStringHelper add(String string2, float f2) {
            this.checkNameAndAppend(string2).append(f2);
            return this;
        }

        public ToStringHelper add(String string2, int n2) {
            this.checkNameAndAppend(string2).append(n2);
            return this;
        }

        public ToStringHelper add(String string2, long l2) {
            this.checkNameAndAppend(string2).append(l2);
            return this;
        }

        public ToStringHelper add(String string2, @Nullable Object object) {
            Preconditions.checkNotNull(string2);
            this.addHolder((Object)object).builder.append(string2).append('=').append(object);
            return this;
        }

        public ToStringHelper add(String string2, boolean bl2) {
            this.checkNameAndAppend(string2).append(bl2);
            return this;
        }

        public ToStringHelper addValue(char c2) {
            this.addHolder().builder.append(c2);
            return this;
        }

        public ToStringHelper addValue(double d2) {
            this.addHolder().builder.append(d2);
            return this;
        }

        public ToStringHelper addValue(float f2) {
            this.addHolder().builder.append(f2);
            return this;
        }

        public ToStringHelper addValue(int n2) {
            this.addHolder().builder.append(n2);
            return this;
        }

        public ToStringHelper addValue(long l2) {
            this.addHolder().builder.append(l2);
            return this;
        }

        public ToStringHelper addValue(@Nullable Object object) {
            this.addHolder((Object)object).builder.append(object);
            return this;
        }

        public ToStringHelper addValue(boolean bl2) {
            this.addHolder().builder.append(bl2);
            return this;
        }

        @Beta
        public ToStringHelper omitNullValues() {
            this.omitNullValues = true;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public String toString() {
            boolean bl2 = this.omitNullValues;
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder(32).append(this.className).append('{');
            Iterator<ValueHolder> iterator = this.valueHolders.iterator();
            while (iterator.hasNext()) {
                ValueHolder valueHolder = iterator.next();
                if (bl2 && valueHolder.isNull) continue;
                if (bl3) {
                    stringBuilder.append(", ");
                } else {
                    bl3 = true;
                }
                stringBuilder.append((CharSequence)valueHolder.builder);
            }
            return stringBuilder.append('}').toString();
        }

        private static final class ValueHolder {
            final StringBuilder builder = new StringBuilder();
            boolean isNull;

            private ValueHolder() {
            }
        }
    }
}

