/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.repackaged.com.google.common.base;

import com.google.api.client.repackaged.com.google.common.annotations.Beta;
import com.google.api.client.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@GwtCompatible
public class Joiner {
    private final String separator;

    private Joiner(Joiner joiner) {
        this.separator = joiner.separator;
    }

    private Joiner(String string2) {
        this.separator = Preconditions.checkNotNull(string2);
    }

    private static Iterable<Object> iterable(final Object object, final Object object2, final Object[] objectArray) {
        Preconditions.checkNotNull(objectArray);
        return new AbstractList<Object>(){

            @Override
            public Object get(int n2) {
                switch (n2) {
                    default: {
                        return objectArray[n2 - 2];
                    }
                    case 0: {
                        return object;
                    }
                    case 1: 
                }
                return object2;
            }

            @Override
            public int size() {
                return 2 + objectArray.length;
            }
        };
    }

    public static Joiner on(char c2) {
        return new Joiner(String.valueOf(c2));
    }

    public static Joiner on(String string2) {
        return new Joiner(string2);
    }

    public <A extends Appendable> A appendTo(A a2, Iterable<?> iterable) throws IOException {
        return this.appendTo(a2, iterable.iterator());
    }

    @Deprecated
    @Beta
    public final <A extends Appendable, I extends Object & Iterator<?>> A appendTo(A a2, I i2) throws IOException {
        return this.appendTo(a2, (Iterator<?>)i2);
    }

    public final <A extends Appendable> A appendTo(A a2, @Nullable Object object, @Nullable Object object2, Object ... objectArray) throws IOException {
        return this.appendTo(a2, (Object & Iterator<?>)Joiner.iterable(object, object2, objectArray));
    }

    public <A extends Appendable> A appendTo(A a2, Iterator<?> iterator) throws IOException {
        Preconditions.checkNotNull(a2);
        if (iterator.hasNext()) {
            a2.append(this.toString(iterator.next()));
            while (iterator.hasNext()) {
                a2.append(this.separator);
                a2.append(this.toString(iterator.next()));
            }
        }
        return a2;
    }

    public final <A extends Appendable> A appendTo(A a2, Object[] objectArray) throws IOException {
        return this.appendTo(a2, (Object & Iterator<?>)Arrays.asList(objectArray));
    }

    public final StringBuilder appendTo(StringBuilder stringBuilder, Iterable<?> iterable) {
        return this.appendTo(stringBuilder, iterable.iterator());
    }

    @Deprecated
    @Beta
    public final <I extends Object & Iterator<?>> StringBuilder appendTo(StringBuilder stringBuilder, I i2) {
        return this.appendTo(stringBuilder, (Iterator<?>)i2);
    }

    public final StringBuilder appendTo(StringBuilder stringBuilder, @Nullable Object object, @Nullable Object object2, Object ... objectArray) {
        return this.appendTo(stringBuilder, (Object & Iterator<?>)Joiner.iterable(object, object2, objectArray));
    }

    public final StringBuilder appendTo(StringBuilder stringBuilder, Iterator<?> iterator) {
        try {
            this.appendTo((Appendable)stringBuilder, iterator);
            return stringBuilder;
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public final StringBuilder appendTo(StringBuilder stringBuilder, Object[] objectArray) {
        return this.appendTo(stringBuilder, (Object & Iterator<?>)Arrays.asList(objectArray));
    }

    public final String join(Iterable<?> iterable) {
        return this.join(iterable.iterator());
    }

    @Deprecated
    @Beta
    public final <I extends Object & Iterator<?>> String join(I i2) {
        return this.join((Iterator<?>)i2);
    }

    public final String join(@Nullable Object object, @Nullable Object object2, Object ... objectArray) {
        return this.join((Object & Iterator<?>)Joiner.iterable(object, object2, objectArray));
    }

    public final String join(Iterator<?> iterator) {
        return this.appendTo(new StringBuilder(), iterator).toString();
    }

    public final String join(Object[] objectArray) {
        return this.join((Object & Iterator<?>)Arrays.asList(objectArray));
    }

    @CheckReturnValue
    public Joiner skipNulls() {
        return new Joiner(this){

            @Override
            public <A extends Appendable> A appendTo(A a2, Iterator<?> iterator) throws IOException {
                Preconditions.checkNotNull(a2, "appendable");
                Preconditions.checkNotNull(iterator, "parts");
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    if (obj == null) continue;
                    a2.append(Joiner.this.toString(obj));
                    break;
                }
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    if (obj == null) continue;
                    a2.append(Joiner.this.separator);
                    a2.append(Joiner.this.toString(obj));
                }
                return a2;
            }

            @Override
            public Joiner useForNull(String string2) {
                Preconditions.checkNotNull(string2);
                throw new UnsupportedOperationException("already specified skipNulls");
            }

            @Override
            public MapJoiner withKeyValueSeparator(String string2) {
                Preconditions.checkNotNull(string2);
                throw new UnsupportedOperationException("can't use .skipNulls() with maps");
            }
        };
    }

    CharSequence toString(Object object) {
        Preconditions.checkNotNull(object);
        if (object instanceof CharSequence) {
            return (CharSequence)object;
        }
        return object.toString();
    }

    @CheckReturnValue
    public Joiner useForNull(final String string2) {
        Preconditions.checkNotNull(string2);
        return new Joiner(this){

            @Override
            public Joiner skipNulls() {
                throw new UnsupportedOperationException("already specified useForNull");
            }

            @Override
            CharSequence toString(Object object) {
                if (object == null) {
                    return string2;
                }
                return Joiner.this.toString(object);
            }

            @Override
            public Joiner useForNull(String string22) {
                Preconditions.checkNotNull(string22);
                throw new UnsupportedOperationException("already specified useForNull");
            }
        };
    }

    @CheckReturnValue
    public MapJoiner withKeyValueSeparator(String string2) {
        return new MapJoiner(this, string2);
    }

    public static final class MapJoiner {
        private final Joiner joiner;
        private final String keyValueSeparator;

        private MapJoiner(Joiner joiner, String string2) {
            this.joiner = joiner;
            this.keyValueSeparator = Preconditions.checkNotNull(string2);
        }

        @Beta
        public <A extends Appendable> A appendTo(A a2, Iterable<? extends Map.Entry<?, ?>> iterable) throws IOException {
            return this.appendTo(a2, iterable.iterator());
        }

        @Deprecated
        @Beta
        public <A extends Appendable, I extends Object & Iterator<? extends Map.Entry<?, ?>>> A appendTo(A a2, I i2) throws IOException {
            return this.appendTo(a2, (Iterator<? extends Map.Entry<?, ?>>)i2);
        }

        @Beta
        public <A extends Appendable> A appendTo(A a2, Iterator<? extends Map.Entry<?, ?>> iterator) throws IOException {
            Preconditions.checkNotNull(a2);
            if (iterator.hasNext()) {
                Map.Entry<?, ?> entry = iterator.next();
                a2.append(this.joiner.toString(entry.getKey()));
                a2.append(this.keyValueSeparator);
                a2.append(this.joiner.toString(entry.getValue()));
                while (iterator.hasNext()) {
                    a2.append(this.joiner.separator);
                    Map.Entry<?, ?> entry2 = iterator.next();
                    a2.append(this.joiner.toString(entry2.getKey()));
                    a2.append(this.keyValueSeparator);
                    a2.append(this.joiner.toString(entry2.getValue()));
                }
            }
            return a2;
        }

        public <A extends Appendable> A appendTo(A a2, Map<?, ?> map) throws IOException {
            return this.appendTo(a2, (Object & Iterator<? extends Map.Entry<?, ?>>)map.entrySet());
        }

        @Beta
        public StringBuilder appendTo(StringBuilder stringBuilder, Iterable<? extends Map.Entry<?, ?>> iterable) {
            return this.appendTo(stringBuilder, iterable.iterator());
        }

        @Deprecated
        @Beta
        public <I extends Object & Iterator<? extends Map.Entry<?, ?>>> StringBuilder appendTo(StringBuilder stringBuilder, I i2) throws IOException {
            return this.appendTo(stringBuilder, (Iterator<? extends Map.Entry<?, ?>>)i2);
        }

        @Beta
        public StringBuilder appendTo(StringBuilder stringBuilder, Iterator<? extends Map.Entry<?, ?>> iterator) {
            try {
                this.appendTo((Appendable)stringBuilder, iterator);
                return stringBuilder;
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public StringBuilder appendTo(StringBuilder stringBuilder, Map<?, ?> map) {
            return this.appendTo(stringBuilder, (Object & Iterator<? extends Map.Entry<?, ?>>)map.entrySet());
        }

        @Beta
        public String join(Iterable<? extends Map.Entry<?, ?>> iterable) {
            return this.join(iterable.iterator());
        }

        @Deprecated
        @Beta
        public <I extends Object & Iterator<? extends Map.Entry<?, ?>>> String join(I i2) throws IOException {
            return this.join((Iterator<? extends Map.Entry<?, ?>>)i2);
        }

        @Beta
        public String join(Iterator<? extends Map.Entry<?, ?>> iterator) {
            return this.appendTo(new StringBuilder(), iterator).toString();
        }

        public String join(Map<?, ?> map) {
            return this.join((Object & Iterator<? extends Map.Entry<?, ?>>)map.entrySet());
        }

        @CheckReturnValue
        public MapJoiner useForNull(String string2) {
            return new MapJoiner(this.joiner.useForNull(string2), this.keyValueSeparator);
        }
    }
}

