/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json.webtoken;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.webtoken.JsonWebToken;
import com.google.api.client.util.Base64;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.SecurityUtils;
import com.google.api.client.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;

@Beta
public class JsonWebSignature
extends JsonWebToken {
    private final byte[] signatureBytes;
    private final byte[] signedContentBytes;

    public JsonWebSignature(Header header, JsonWebToken.Payload payload, byte[] byArray, byte[] byArray2) {
        super(header, payload);
        this.signatureBytes = Preconditions.checkNotNull(byArray);
        this.signedContentBytes = Preconditions.checkNotNull(byArray2);
    }

    public static JsonWebSignature parse(JsonFactory jsonFactory, String string2) throws IOException {
        return JsonWebSignature.parser(jsonFactory).parse(string2);
    }

    public static Parser parser(JsonFactory jsonFactory) {
        return new Parser(jsonFactory);
    }

    public static String signUsingRsaSha256(PrivateKey privateKey, JsonFactory jsonFactory, Header header, JsonWebToken.Payload payload) throws GeneralSecurityException, IOException {
        String string2 = Base64.encodeBase64URLSafeString(jsonFactory.toByteArray(header)) + "." + Base64.encodeBase64URLSafeString(jsonFactory.toByteArray(payload));
        byte[] byArray = StringUtils.getBytesUtf8(string2);
        byte[] byArray2 = SecurityUtils.sign(SecurityUtils.getSha256WithRsaSignatureAlgorithm(), privateKey, byArray);
        return string2 + "." + Base64.encodeBase64URLSafeString(byArray2);
    }

    @Override
    public Header getHeader() {
        return (Header)super.getHeader();
    }

    public final byte[] getSignatureBytes() {
        return this.signatureBytes;
    }

    public final byte[] getSignedContentBytes() {
        return this.signedContentBytes;
    }

    public final boolean verifySignature(PublicKey publicKey) throws GeneralSecurityException {
        if ("RS256".equals(this.getHeader().getAlgorithm())) {
            return SecurityUtils.verify(SecurityUtils.getSha256WithRsaSignatureAlgorithm(), publicKey, this.signatureBytes, this.signedContentBytes);
        }
        return false;
    }

    @Beta
    public static class Header
    extends JsonWebToken.Header {
        @Key(value="alg")
        private String algorithm;
        @Key(value="crit")
        private List<String> critical;
        @Key(value="jwk")
        private String jwk;
        @Key(value="jku")
        private String jwkUrl;
        @Key(value="kid")
        private String keyId;
        @Key(value="x5c")
        private String x509Certificate;
        @Key(value="x5t")
        private String x509Thumbprint;
        @Key(value="x5u")
        private String x509Url;

        @Override
        public Header clone() {
            return (Header)super.clone();
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        public final List<String> getCritical() {
            return this.critical;
        }

        public final String getJwk() {
            return this.jwk;
        }

        public final String getJwkUrl() {
            return this.jwkUrl;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final String getX509Certificate() {
            return this.x509Certificate;
        }

        public final String getX509Thumbprint() {
            return this.x509Thumbprint;
        }

        public final String getX509Url() {
            return this.x509Url;
        }

        @Override
        public Header set(String string2, Object object) {
            return (Header)super.set(string2, object);
        }

        public Header setAlgorithm(String string2) {
            this.algorithm = string2;
            return this;
        }

        public Header setCritical(List<String> list) {
            this.critical = list;
            return this;
        }

        public Header setJwk(String string2) {
            this.jwk = string2;
            return this;
        }

        public Header setJwkUrl(String string2) {
            this.jwkUrl = string2;
            return this;
        }

        public Header setKeyId(String string2) {
            this.keyId = string2;
            return this;
        }

        @Override
        public Header setType(String string2) {
            super.setType(string2);
            return this;
        }

        public Header setX509Certificate(String string2) {
            this.x509Certificate = string2;
            return this;
        }

        public Header setX509Thumbprint(String string2) {
            this.x509Thumbprint = string2;
            return this;
        }

        public Header setX509Url(String string2) {
            this.x509Url = string2;
            return this;
        }
    }

    @Beta
    public static final class Parser {
        private Class<? extends Header> headerClass = Header.class;
        private final JsonFactory jsonFactory;
        private Class<? extends JsonWebToken.Payload> payloadClass = JsonWebToken.Payload.class;

        public Parser(JsonFactory jsonFactory) {
            this.jsonFactory = Preconditions.checkNotNull(jsonFactory);
        }

        public Class<? extends Header> getHeaderClass() {
            return this.headerClass;
        }

        public JsonFactory getJsonFactory() {
            return this.jsonFactory;
        }

        public Class<? extends JsonWebToken.Payload> getPayloadClass() {
            return this.payloadClass;
        }

        /*
         * Enabled aggressive block sorting
         */
        public JsonWebSignature parse(String string2) throws IOException {
            boolean bl2 = true;
            int n2 = string2.indexOf(46);
            boolean bl3 = n2 != -1 ? bl2 : false;
            Preconditions.checkArgument(bl3);
            byte[] byArray = Base64.decodeBase64(string2.substring(0, n2));
            int n3 = string2.indexOf(46, n2 + 1);
            boolean bl4 = n3 != -1 ? bl2 : false;
            Preconditions.checkArgument(bl4);
            boolean bl5 = string2.indexOf(46, n3 + 1) == -1 ? bl2 : false;
            Preconditions.checkArgument(bl5);
            byte[] byArray2 = Base64.decodeBase64(string2.substring(n2 + 1, n3));
            byte[] byArray3 = Base64.decodeBase64(string2.substring(n3 + 1));
            byte[] byArray4 = StringUtils.getBytesUtf8(string2.substring(0, n3));
            Header header = this.jsonFactory.fromInputStream(new ByteArrayInputStream(byArray), this.headerClass);
            if (header.getAlgorithm() == null) {
                bl2 = false;
            }
            Preconditions.checkArgument(bl2);
            return new JsonWebSignature(header, this.jsonFactory.fromInputStream(new ByteArrayInputStream(byArray2), this.payloadClass), byArray3, byArray4);
        }

        public Parser setHeaderClass(Class<? extends Header> clazz) {
            this.headerClass = clazz;
            return this;
        }

        public Parser setPayloadClass(Class<? extends JsonWebToken.Payload> clazz) {
            this.payloadClass = clazz;
            return this;
        }
    }
}

