/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json;

import com.google.api.client.json.CustomizeJsonParser;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonPolymorphicTypeMap;
import com.google.api.client.json.JsonToken;
import com.google.api.client.util.Beta;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.Data;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Sets;
import com.google.api.client.util.Types;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class JsonParser {
    private static WeakHashMap<Class<?>, Field> cachedTypemapFields = new WeakHashMap();
    private static final Lock lock = new ReentrantLock();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Field getCachedTypemapFieldFor(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        lock.lock();
        if (cachedTypemapFields.containsKey(clazz)) {
            Field field = cachedTypemapFields.get(clazz);
            lock.unlock();
            return field;
        }
        Field field = null;
        Iterator<FieldInfo> iterator = ClassInfo.of(clazz).getFieldInfos().iterator();
        while (iterator.hasNext()) {
            Field field2 = iterator.next().getField();
            JsonPolymorphicTypeMap jsonPolymorphicTypeMap = field2.getAnnotation(JsonPolymorphicTypeMap.class);
            if (jsonPolymorphicTypeMap == null) continue;
            boolean bl2 = field == null;
            Preconditions.checkArgument(bl2, "Class contains more than one field with @JsonPolymorphicTypeMap annotation: %s", clazz);
            boolean bl3 = Data.isPrimitive(field2.getType());
            Object[] objectArray = new Object[]{clazz, field2.getType()};
            Preconditions.checkArgument(bl3, "Field which has the @JsonPolymorphicTypeMap, %s, is not a supported type: %s", objectArray);
            field = field2;
            JsonPolymorphicTypeMap.TypeDef[] typeDefArray = jsonPolymorphicTypeMap.typeDefinitions();
            HashSet<String> hashSet = Sets.newHashSet();
            boolean bl4 = typeDefArray.length > 0;
            Preconditions.checkArgument(bl4, "@JsonPolymorphicTypeMap must have at least one @TypeDef");
            for (JsonPolymorphicTypeMap.TypeDef typeDef : typeDefArray) {
                boolean bl5 = hashSet.add(typeDef.key());
                Object[] objectArray2 = new Object[]{typeDef.key()};
                Preconditions.checkArgument(bl5, "Class contains two @TypeDef annotations with identical key: %s", objectArray2);
            }
        }
        cachedTypemapFields.put(clazz, field);
        return field;
    }

    /*
     * Unable to fully structure code
     */
    private void parse(ArrayList<Type> var1_1, Object var2_2, CustomizeJsonParser var3_3) throws IOException {
        if (var2_2 instanceof GenericJson) {
            ((GenericJson)var2_2).setFactory(this.getFactory());
        }
        var4_4 = this.startParsingObjectOrArray();
        var5_5 = var2_2.getClass();
        var6_6 = ClassInfo.of(var5_5);
        var7_7 = GenericData.class.isAssignableFrom(var5_5);
        if (var7_7 || !Map.class.isAssignableFrom(var5_5)) ** GOTO lbl21
        this.parseMap(null, (Map)var2_2, Types.getMapValueParameter(var5_5), var1_1, var3_3);
lbl9:
        // 3 sources

        return;
        {
            var14_11 = var11_10.getField();
            var15_12 = var1_1.size();
            var1_1.add(var14_11.getGenericType());
            var17_13 = this.parseValue(var14_11, var11_10.getGenericType(), var1_1, var2_2, var3_3, true);
            var1_1.remove(var15_12);
            var11_10.setValue(var2_2, var17_13);
            while (true) {
                var4_4 = this.nextToken();
lbl21:
                // 2 sources

                if (var4_4 != (var8_8 = JsonToken.FIELD_NAME)) ** GOTO lbl9
                var9_9 = this.getText();
                this.nextToken();
                if (var3_3 == null || !var3_3.stopAt(var2_2, var9_9)) ** break;
                ** continue;
                var11_10 = var6_6.getFieldInfo(var9_9);
                if (var11_10 != null) {
                    if (!var11_10.isFinal() || var11_10.isPrimitive()) continue block1;
                    throw new IllegalArgumentException("final array/object fields are not supported");
                }
                if (var7_7) {
                    ((GenericData)var2_2).set(var9_9, this.parseValue(null, null, var1_1, var2_2, var3_3, true));
                    continue;
                }
                if (var3_3 != null) {
                    var3_3.handleUnrecognizedKey(var2_2, var9_9);
                }
                this.skipChildren();
            }
        }
    }

    private <T> void parseArray(Field field, Collection<T> collection, Type type, ArrayList<Type> arrayList, CustomizeJsonParser customizeJsonParser) throws IOException {
        JsonToken jsonToken = this.startParsingObjectOrArray();
        while (jsonToken != JsonToken.END_ARRAY) {
            collection.add(this.parseValue(field, type, arrayList, collection, customizeJsonParser, true));
            jsonToken = this.nextToken();
        }
    }

    private void parseMap(Field field, Map<String, Object> map, Type type, ArrayList<Type> arrayList, CustomizeJsonParser customizeJsonParser) throws IOException {
        JsonToken jsonToken = this.startParsingObjectOrArray();
        while (true) {
            String string2;
            block4: {
                block3: {
                    if (jsonToken != JsonToken.FIELD_NAME) break block3;
                    string2 = this.getText();
                    this.nextToken();
                    if (customizeJsonParser == null || !customizeJsonParser.stopAt(map, string2)) break block4;
                }
                return;
            }
            map.put(string2, this.parseValue(field, type, arrayList, map, customizeJsonParser, true));
            jsonToken = this.nextToken();
        }
    }

    /*
     * Exception decompiling
     */
    private final Object parseValue(Field var1_1, Type var2_2, ArrayList<Type> var3_3, Object var4_4, CustomizeJsonParser var5_5, boolean var6_6) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 251->258)] java.lang.IllegalArgumentException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    private JsonToken startParsing() throws IOException {
        JsonToken jsonToken = this.getCurrentToken();
        if (jsonToken == null) {
            jsonToken = this.nextToken();
        }
        boolean bl2 = jsonToken != null;
        Preconditions.checkArgument(bl2, "no JSON input found");
        return jsonToken;
    }

    /*
     * Enabled aggressive block sorting
     */
    private JsonToken startParsingObjectOrArray() throws IOException {
        JsonToken jsonToken = this.startParsing();
        switch (jsonToken) {
            default: {
                return jsonToken;
            }
            case START_OBJECT: {
                JsonToken jsonToken2 = this.nextToken();
                boolean bl2 = jsonToken2 == JsonToken.FIELD_NAME || jsonToken2 == JsonToken.END_OBJECT;
                Preconditions.checkArgument(bl2, (Object)jsonToken2);
                return jsonToken2;
            }
            case START_ARRAY: 
        }
        return this.nextToken();
    }

    public abstract void close() throws IOException;

    public abstract BigInteger getBigIntegerValue() throws IOException;

    public abstract byte getByteValue() throws IOException;

    public abstract String getCurrentName() throws IOException;

    public abstract JsonToken getCurrentToken();

    public abstract BigDecimal getDecimalValue() throws IOException;

    public abstract double getDoubleValue() throws IOException;

    public abstract JsonFactory getFactory();

    public abstract float getFloatValue() throws IOException;

    public abstract int getIntValue() throws IOException;

    public abstract long getLongValue() throws IOException;

    public abstract short getShortValue() throws IOException;

    public abstract String getText() throws IOException;

    public abstract JsonToken nextToken() throws IOException;

    public final <T> T parse(Class<T> clazz) throws IOException {
        return this.parse(clazz, null);
    }

    @Beta
    public final <T> T parse(Class<T> clazz, CustomizeJsonParser customizeJsonParser) throws IOException {
        return (T)this.parse(clazz, false, customizeJsonParser);
    }

    public Object parse(Type type, boolean bl2) throws IOException {
        return this.parse(type, bl2, null);
    }

    @Beta
    public Object parse(Type type, boolean bl2, CustomizeJsonParser customizeJsonParser) throws IOException {
        try {
            if (!Void.class.equals((Object)type)) {
                this.startParsing();
            }
            Object object = this.parseValue(null, type, new ArrayList<Type>(), null, customizeJsonParser, true);
            return object;
        }
        finally {
            if (bl2) {
                this.close();
            }
        }
    }

    public final void parse(Object object) throws IOException {
        this.parse(object, null);
    }

    @Beta
    public final void parse(Object object, CustomizeJsonParser customizeJsonParser) throws IOException {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        arrayList.add(object.getClass());
        this.parse(arrayList, object, customizeJsonParser);
    }

    public final <T> T parseAndClose(Class<T> clazz) throws IOException {
        return this.parseAndClose(clazz, null);
    }

    @Beta
    public final <T> T parseAndClose(Class<T> clazz, CustomizeJsonParser customizeJsonParser) throws IOException {
        try {
            T t2 = this.parse(clazz, customizeJsonParser);
            return t2;
        }
        finally {
            this.close();
        }
    }

    public final void parseAndClose(Object object) throws IOException {
        this.parseAndClose(object, null);
    }

    @Beta
    public final void parseAndClose(Object object, CustomizeJsonParser customizeJsonParser) throws IOException {
        try {
            this.parse(object, customizeJsonParser);
            return;
        }
        finally {
            this.close();
        }
    }

    public final <T> Collection<T> parseArray(Class<?> clazz, Class<T> clazz2) throws IOException {
        return this.parseArray(clazz, clazz2, null);
    }

    @Beta
    public final <T> Collection<T> parseArray(Class<?> clazz, Class<T> clazz2, CustomizeJsonParser customizeJsonParser) throws IOException {
        Collection<Object> collection = Data.newCollectionInstance(clazz);
        this.parseArray(collection, clazz2, customizeJsonParser);
        return collection;
    }

    public final <T> void parseArray(Collection<? super T> collection, Class<T> clazz) throws IOException {
        this.parseArray(collection, clazz, null);
    }

    @Beta
    public final <T> void parseArray(Collection<? super T> collection, Class<T> clazz, CustomizeJsonParser customizeJsonParser) throws IOException {
        this.parseArray(null, collection, clazz, new ArrayList<Type>(), customizeJsonParser);
    }

    public final <T> Collection<T> parseArrayAndClose(Class<?> clazz, Class<T> clazz2) throws IOException {
        return this.parseArrayAndClose(clazz, clazz2, null);
    }

    @Beta
    public final <T> Collection<T> parseArrayAndClose(Class<?> clazz, Class<T> clazz2, CustomizeJsonParser customizeJsonParser) throws IOException {
        try {
            Collection<T> collection = this.parseArray(clazz, clazz2, customizeJsonParser);
            return collection;
        }
        finally {
            this.close();
        }
    }

    public final <T> void parseArrayAndClose(Collection<? super T> collection, Class<T> clazz) throws IOException {
        this.parseArrayAndClose(collection, clazz, null);
    }

    @Beta
    public final <T> void parseArrayAndClose(Collection<? super T> collection, Class<T> clazz, CustomizeJsonParser customizeJsonParser) throws IOException {
        try {
            this.parseArray(collection, clazz, customizeJsonParser);
            return;
        }
        finally {
            this.close();
        }
    }

    public abstract JsonParser skipChildren() throws IOException;

    public final String skipToKey(Set<String> set) throws IOException {
        JsonToken jsonToken = this.startParsingObjectOrArray();
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string2 = this.getText();
            this.nextToken();
            if (set.contains(string2)) {
                return string2;
            }
            this.skipChildren();
            jsonToken = this.nextToken();
        }
        return null;
    }

    public final void skipToKey(String string2) throws IOException {
        this.skipToKey(Collections.singleton(string2));
    }
}

