/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.JsonToken;
import com.google.api.client.util.ObjectParser;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class JsonObjectParser
implements ObjectParser {
    private final JsonFactory jsonFactory;
    private final Set<String> wrapperKeys;

    public JsonObjectParser(JsonFactory jsonFactory) {
        this(new Builder(jsonFactory));
    }

    protected JsonObjectParser(Builder builder) {
        this.jsonFactory = builder.jsonFactory;
        this.wrapperKeys = new HashSet<String>(builder.wrapperKeys);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeParser(JsonParser jsonParser) throws IOException {
        boolean bl2 = true;
        if (this.wrapperKeys.isEmpty()) {
            return;
        }
        try {
            if (jsonParser.skipToKey(this.wrapperKeys) == null || jsonParser.getCurrentToken() == JsonToken.END_OBJECT) {
                bl2 = false;
            }
            Object[] objectArray = new Object[]{this.wrapperKeys};
            Preconditions.checkArgument(bl2, "wrapper key(s) not found: %s", objectArray);
            return;
        }
        catch (Throwable throwable) {
            jsonParser.close();
            throw throwable;
        }
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public Set<String> getWrapperKeys() {
        return Collections.unmodifiableSet(this.wrapperKeys);
    }

    @Override
    public <T> T parseAndClose(InputStream inputStream, Charset charset, Class<T> clazz) throws IOException {
        return (T)this.parseAndClose(inputStream, charset, (Type)clazz);
    }

    @Override
    public Object parseAndClose(InputStream inputStream, Charset charset, Type type) throws IOException {
        JsonParser jsonParser = this.jsonFactory.createJsonParser(inputStream, charset);
        this.initializeParser(jsonParser);
        return jsonParser.parse(type, true);
    }

    @Override
    public <T> T parseAndClose(Reader reader, Class<T> clazz) throws IOException {
        return (T)this.parseAndClose(reader, (Type)clazz);
    }

    @Override
    public Object parseAndClose(Reader reader, Type type) throws IOException {
        JsonParser jsonParser = this.jsonFactory.createJsonParser(reader);
        this.initializeParser(jsonParser);
        return jsonParser.parse(type, true);
    }

    public static class Builder {
        final JsonFactory jsonFactory;
        Collection<String> wrapperKeys = Sets.newHashSet();

        public Builder(JsonFactory jsonFactory) {
            this.jsonFactory = Preconditions.checkNotNull(jsonFactory);
        }

        public JsonObjectParser build() {
            return new JsonObjectParser(this);
        }

        public final JsonFactory getJsonFactory() {
            return this.jsonFactory;
        }

        public final Collection<String> getWrapperKeys() {
            return this.wrapperKeys;
        }

        public Builder setWrapperKeys(Collection<String> collection) {
            this.wrapperKeys = collection;
            return this;
        }
    }
}

