/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonString;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.Data;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Types;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;

public abstract class JsonGenerator {
    /*
     * Enabled aggressive block sorting
     */
    private void serialize(boolean bl2, Object object) throws IOException {
        if (object == null) {
            return;
        }
        Class<?> clazz = object.getClass();
        if (Data.isNull(object)) {
            this.writeNull();
            return;
        }
        if (object instanceof String) {
            this.writeString((String)object);
            return;
        }
        if (object instanceof Number) {
            if (bl2) {
                this.writeString(object.toString());
                return;
            }
            if (object instanceof BigDecimal) {
                this.writeNumber((BigDecimal)object);
                return;
            }
            if (object instanceof BigInteger) {
                this.writeNumber((BigInteger)object);
                return;
            }
            if (object instanceof Long) {
                this.writeNumber((Long)object);
                return;
            }
            if (object instanceof Float) {
                float f2 = ((Number)object).floatValue();
                boolean bl3 = !Float.isInfinite(f2) && !Float.isNaN(f2);
                Preconditions.checkArgument(bl3);
                this.writeNumber(f2);
                return;
            }
            if (object instanceof Integer || object instanceof Short || object instanceof Byte) {
                this.writeNumber(((Number)object).intValue());
                return;
            }
            double d2 = ((Number)object).doubleValue();
            boolean bl4 = !Double.isInfinite(d2) && !Double.isNaN(d2);
            Preconditions.checkArgument(bl4);
            this.writeNumber(d2);
            return;
        }
        if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
            return;
        }
        if (object instanceof DateTime) {
            this.writeString(((DateTime)object).toStringRfc3339());
            return;
        }
        if (object instanceof Iterable || clazz.isArray()) {
            this.writeStartArray();
            Iterator iterator = Types.iterableOf(object).iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.writeEndArray();
                    return;
                }
                this.serialize(bl2, iterator.next());
            }
        }
        if (clazz.isEnum()) {
            String string2 = FieldInfo.of((Enum)object).getName();
            if (string2 == null) {
                this.writeNull();
                return;
            }
            this.writeString(string2);
            return;
        }
        this.writeStartObject();
        boolean bl5 = object instanceof Map && !(object instanceof GenericData);
        ClassInfo classInfo = bl5 ? null : ClassInfo.of(clazz);
        Iterator<Map.Entry<String, Object>> iterator = Data.mapOf(object).entrySet().iterator();
        while (true) {
            Field field;
            if (!iterator.hasNext()) {
                this.writeEndObject();
                return;
            }
            Map.Entry<String, Object> entry = iterator.next();
            Object object2 = entry.getValue();
            if (object2 == null) continue;
            String string3 = entry.getKey();
            boolean bl6 = bl5 ? bl2 : (field = classInfo.getField(string3)) != null && field.getAnnotation(JsonString.class) != null;
            this.writeFieldName(string3);
            this.serialize(bl6, object2);
        }
    }

    public abstract void close() throws IOException;

    public void enablePrettyPrint() throws IOException {
    }

    public abstract void flush() throws IOException;

    public abstract JsonFactory getFactory();

    public final void serialize(Object object) throws IOException {
        this.serialize(false, object);
    }

    public abstract void writeBoolean(boolean var1) throws IOException;

    public abstract void writeEndArray() throws IOException;

    public abstract void writeEndObject() throws IOException;

    public abstract void writeFieldName(String var1) throws IOException;

    public abstract void writeNull() throws IOException;

    public abstract void writeNumber(double var1) throws IOException;

    public abstract void writeNumber(float var1) throws IOException;

    public abstract void writeNumber(int var1) throws IOException;

    public abstract void writeNumber(long var1) throws IOException;

    public abstract void writeNumber(String var1) throws IOException;

    public abstract void writeNumber(BigDecimal var1) throws IOException;

    public abstract void writeNumber(BigInteger var1) throws IOException;

    public abstract void writeStartArray() throws IOException;

    public abstract void writeStartObject() throws IOException;

    public abstract void writeString(String var1) throws IOException;
}

