/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json;

import com.google.api.client.json.JsonGenerator;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.JsonParser;
import com.google.api.client.util.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public abstract class JsonFactory {
    private ByteArrayOutputStream toByteStream(Object object, boolean bl2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JsonGenerator jsonGenerator = this.createJsonGenerator(byteArrayOutputStream, Charsets.UTF_8);
        if (bl2) {
            jsonGenerator.enablePrettyPrint();
        }
        jsonGenerator.serialize(object);
        jsonGenerator.flush();
        return byteArrayOutputStream;
    }

    private String toString(Object object, boolean bl2) throws IOException {
        return this.toByteStream(object, bl2).toString("UTF-8");
    }

    public abstract JsonGenerator createJsonGenerator(OutputStream var1, Charset var2) throws IOException;

    public abstract JsonGenerator createJsonGenerator(Writer var1) throws IOException;

    public final JsonObjectParser createJsonObjectParser() {
        return new JsonObjectParser(this);
    }

    public abstract JsonParser createJsonParser(InputStream var1) throws IOException;

    public abstract JsonParser createJsonParser(InputStream var1, Charset var2) throws IOException;

    public abstract JsonParser createJsonParser(Reader var1) throws IOException;

    public abstract JsonParser createJsonParser(String var1) throws IOException;

    public final <T> T fromInputStream(InputStream inputStream, Class<T> clazz) throws IOException {
        return this.createJsonParser(inputStream).parseAndClose(clazz);
    }

    public final <T> T fromInputStream(InputStream inputStream, Charset charset, Class<T> clazz) throws IOException {
        return this.createJsonParser(inputStream, charset).parseAndClose(clazz);
    }

    public final <T> T fromReader(Reader reader, Class<T> clazz) throws IOException {
        return this.createJsonParser(reader).parseAndClose(clazz);
    }

    public final <T> T fromString(String string2, Class<T> clazz) throws IOException {
        return this.createJsonParser(string2).parse(clazz);
    }

    public final byte[] toByteArray(Object object) throws IOException {
        return this.toByteStream(object, false).toByteArray();
    }

    public final String toPrettyString(Object object) throws IOException {
        return this.toString(object, true);
    }

    public final String toString(Object object) throws IOException {
        return this.toString(object, false);
    }
}

