/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.json;

import com.google.api.client.http.AbstractHttpContent;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.json.Json;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonGenerator;
import com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.io.OutputStream;

public class JsonHttpContent
extends AbstractHttpContent {
    private final Object data;
    private final JsonFactory jsonFactory;
    private String wrapperKey;

    public JsonHttpContent(JsonFactory jsonFactory, Object object) {
        super(Json.MEDIA_TYPE);
        this.jsonFactory = Preconditions.checkNotNull(jsonFactory);
        this.data = Preconditions.checkNotNull(object);
    }

    public final Object getData() {
        return this.data;
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public final String getWrapperKey() {
        return this.wrapperKey;
    }

    @Override
    public JsonHttpContent setMediaType(HttpMediaType httpMediaType) {
        super.setMediaType(httpMediaType);
        return this;
    }

    public JsonHttpContent setWrapperKey(String string2) {
        this.wrapperKey = string2;
        return this;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        JsonGenerator jsonGenerator = this.jsonFactory.createJsonGenerator(outputStream, this.getCharset());
        if (this.wrapperKey != null) {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName(this.wrapperKey);
        }
        jsonGenerator.serialize(this.data);
        if (this.wrapperKey != null) {
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.flush();
    }
}

