/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.javanet;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpRequest;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.SecurityUtils;
import com.google.api.client.util.SslUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public final class NetHttpTransport
extends HttpTransport {
    private static final String[] SUPPORTED_METHODS = new String[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"};
    private final HostnameVerifier hostnameVerifier;
    private final Proxy proxy;
    private final SSLSocketFactory sslSocketFactory;

    static {
        Arrays.sort(SUPPORTED_METHODS);
    }

    public NetHttpTransport() {
        this(null, null, null);
    }

    NetHttpTransport(Proxy proxy, SSLSocketFactory sSLSocketFactory, HostnameVerifier hostnameVerifier) {
        this.proxy = proxy;
        this.sslSocketFactory = sSLSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected NetHttpRequest buildRequest(String string2, String string3) throws IOException {
        Preconditions.checkArgument(this.supportsMethod(string2), "HTTP method %s not supported", string2);
        URL uRL = new URL(string3);
        URLConnection uRLConnection = this.proxy == null ? uRL.openConnection() : uRL.openConnection(this.proxy);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        httpURLConnection.setRequestMethod(string2);
        if (httpURLConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            if (this.hostnameVerifier != null) {
                httpsURLConnection.setHostnameVerifier(this.hostnameVerifier);
            }
            if (this.sslSocketFactory != null) {
                httpsURLConnection.setSSLSocketFactory(this.sslSocketFactory);
            }
        }
        return new NetHttpRequest(httpURLConnection);
    }

    @Override
    public boolean supportsMethod(String string2) {
        return Arrays.binarySearch(SUPPORTED_METHODS, string2) >= 0;
    }

    public static final class Builder {
        private HostnameVerifier hostnameVerifier;
        private Proxy proxy;
        private SSLSocketFactory sslSocketFactory;

        public NetHttpTransport build() {
            return new NetHttpTransport(this.proxy, this.sslSocketFactory, this.hostnameVerifier);
        }

        @Beta
        public Builder doNotValidateCertificate() throws GeneralSecurityException {
            this.hostnameVerifier = SslUtils.trustAllHostnameVerifier();
            this.sslSocketFactory = SslUtils.trustAllSSLContext().getSocketFactory();
            return this;
        }

        public HostnameVerifier getHostnameVerifier() {
            return this.hostnameVerifier;
        }

        public SSLSocketFactory getSslSocketFactory() {
            return this.sslSocketFactory;
        }

        public Builder setHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder setProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder setSslSocketFactory(SSLSocketFactory sSLSocketFactory) {
            this.sslSocketFactory = sSLSocketFactory;
            return this;
        }

        public Builder trustCertificates(KeyStore keyStore) throws GeneralSecurityException {
            SSLContext sSLContext = SslUtils.getTlsSslContext();
            SslUtils.initSslContext(sSLContext, keyStore, SslUtils.getPkixTrustManagerFactory());
            return this.setSslSocketFactory(sSLContext.getSocketFactory());
        }

        public Builder trustCertificatesFromJavaKeyStore(InputStream inputStream, String string2) throws GeneralSecurityException, IOException {
            KeyStore keyStore = SecurityUtils.getJavaKeyStore();
            SecurityUtils.loadKeyStore(keyStore, inputStream, string2);
            return this.trustCertificates(keyStore);
        }

        public Builder trustCertificatesFromStream(InputStream inputStream) throws GeneralSecurityException, IOException {
            KeyStore keyStore = SecurityUtils.getJavaKeyStore();
            keyStore.load(null, null);
            SecurityUtils.loadKeyStoreFromCertificates(keyStore, SecurityUtils.getX509CertificateFactory(), inputStream);
            return this.trustCertificates(keyStore);
        }
    }
}

