/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.javanet;

import com.google.api.client.http.LowLevelHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class NetHttpResponse
extends LowLevelHttpResponse {
    private final HttpURLConnection connection;
    private final ArrayList<String> headerNames = new ArrayList();
    private final ArrayList<String> headerValues = new ArrayList();
    private final int responseCode;
    private final String responseMessage;

    NetHttpResponse(HttpURLConnection httpURLConnection) throws IOException {
        this.connection = httpURLConnection;
        int n2 = httpURLConnection.getResponseCode();
        if (n2 == -1) {
            n2 = 0;
        }
        this.responseCode = n2;
        this.responseMessage = httpURLConnection.getResponseMessage();
        ArrayList<String> arrayList = this.headerNames;
        ArrayList<String> arrayList2 = this.headerValues;
        for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
            String string2 = entry.getKey();
            if (string2 == null) continue;
            for (String string3 : entry.getValue()) {
                if (string3 == null) continue;
                arrayList.add(string2);
                arrayList2.add(string3);
            }
        }
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
    }

    @Override
    public InputStream getContent() throws IOException {
        try {
            InputStream inputStream = this.connection.getInputStream();
            return inputStream;
        }
        catch (IOException iOException) {
            return this.connection.getErrorStream();
        }
    }

    @Override
    public String getContentEncoding() {
        return this.connection.getContentEncoding();
    }

    @Override
    public long getContentLength() {
        String string2 = this.connection.getHeaderField("Content-Length");
        if (string2 == null) {
            return -1L;
        }
        return Long.parseLong(string2);
    }

    @Override
    public String getContentType() {
        return this.connection.getHeaderField("Content-Type");
    }

    @Override
    public int getHeaderCount() {
        return this.headerNames.size();
    }

    @Override
    public String getHeaderName(int n2) {
        return this.headerNames.get(n2);
    }

    @Override
    public String getHeaderValue(int n2) {
        return this.headerValues.get(n2);
    }

    @Override
    public String getReasonPhrase() {
        return this.responseMessage;
    }

    @Override
    public int getStatusCode() {
        return this.responseCode;
    }

    @Override
    public String getStatusLine() {
        String string2 = this.connection.getHeaderField(0);
        if (string2 != null && string2.startsWith("HTTP/1.")) {
            return string2;
        }
        return null;
    }
}

