/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.javanet;

import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.http.javanet.NetHttpResponse;
import com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;

final class NetHttpRequest
extends LowLevelHttpRequest {
    private final HttpURLConnection connection;

    NetHttpRequest(HttpURLConnection httpURLConnection) {
        this.connection = httpURLConnection;
        httpURLConnection.setInstanceFollowRedirects(false);
    }

    @Override
    public void addHeader(String string2, String string3) {
        this.connection.addRequestProperty(string2, string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LowLevelHttpResponse execute() throws IOException {
        HttpURLConnection httpURLConnection = this.connection;
        if (this.getStreamingContent() != null) {
            String string2;
            long l2;
            String string3;
            String string4 = this.getContentType();
            if (string4 != null) {
                this.addHeader("Content-Type", string4);
            }
            if ((string3 = this.getContentEncoding()) != null) {
                this.addHeader("Content-Encoding", string3);
            }
            if ((l2 = this.getContentLength()) >= 0L) {
                this.addHeader("Content-Length", Long.toString(l2));
            }
            if ("POST".equals(string2 = httpURLConnection.getRequestMethod()) || "PUT".equals(string2)) {
                httpURLConnection.setDoOutput(true);
                if (l2 >= 0L && l2 <= Integer.MAX_VALUE) {
                    httpURLConnection.setFixedLengthStreamingMode((int)l2);
                } else {
                    httpURLConnection.setChunkedStreamingMode(0);
                }
                OutputStream outputStream = httpURLConnection.getOutputStream();
                try {
                    this.getStreamingContent().writeTo(outputStream);
                }
                finally {
                    outputStream.close();
                }
            } else {
                boolean bl2 = l2 == 0L;
                Preconditions.checkArgument(bl2, "%s with non-zero content length is not supported", string2);
            }
        }
        try {
            httpURLConnection.connect();
            return new NetHttpResponse(httpURLConnection);
        }
        catch (Throwable throwable) {
            httpURLConnection.disconnect();
            throw throwable;
        }
    }

    @Override
    public void setTimeout(int n2, int n3) {
        this.connection.setReadTimeout(n3);
        this.connection.setConnectTimeout(n2);
    }
}

