/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.apache;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.ApacheHttpRequest;
import com.google.api.client.http.apache.HttpExtensionMethod;
import com.google.api.client.http.apache.SSLSocketFactoryExtension;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.SecurityUtils;
import com.google.api.client.util.SslUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public final class ApacheHttpTransport
extends HttpTransport {
    private final HttpClient httpClient;

    public ApacheHttpTransport() {
        this((HttpClient)ApacheHttpTransport.newDefaultHttpClient());
    }

    public ApacheHttpTransport(HttpClient httpClient) {
        this.httpClient = httpClient;
        HttpParams httpParams = httpClient.getParams();
        HttpProtocolParams.setVersion((HttpParams)httpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        httpParams.setBooleanParameter("http.protocol.handle-redirects", false);
    }

    public static DefaultHttpClient newDefaultHttpClient() {
        return ApacheHttpTransport.newDefaultHttpClient(SSLSocketFactory.getSocketFactory(), ApacheHttpTransport.newDefaultHttpParams(), ProxySelector.getDefault());
    }

    static DefaultHttpClient newDefaultHttpClient(SSLSocketFactory sSLSocketFactory, HttpParams httpParams, ProxySelector proxySelector) {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)sSLSocketFactory, 443));
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager(httpParams, schemeRegistry), httpParams);
        defaultHttpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        if (proxySelector != null) {
            defaultHttpClient.setRoutePlanner((HttpRoutePlanner)new ProxySelectorRoutePlanner(schemeRegistry, proxySelector));
        }
        return defaultHttpClient;
    }

    static HttpParams newDefaultHttpParams() {
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)basicHttpParams, (boolean)false);
        HttpConnectionParams.setSocketBufferSize((HttpParams)basicHttpParams, (int)8192);
        ConnManagerParams.setMaxTotalConnections((HttpParams)basicHttpParams, (int)200);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)basicHttpParams, (ConnPerRoute)new ConnPerRouteBean(20));
        return basicHttpParams;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected ApacheHttpRequest buildRequest(String string2, String string3) {
        void var3_4;
        if (string2.equals("DELETE")) {
            HttpDelete httpDelete = new HttpDelete(string3);
            return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)var3_4);
        }
        if (string2.equals("GET")) {
            HttpGet httpGet = new HttpGet(string3);
            return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)var3_4);
        }
        if (string2.equals("HEAD")) {
            HttpHead httpHead = new HttpHead(string3);
            return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)var3_4);
        }
        if (string2.equals("POST")) {
            HttpPost httpPost = new HttpPost(string3);
            return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)var3_4);
        }
        if (string2.equals("PUT")) {
            HttpPut httpPut = new HttpPut(string3);
            return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)var3_4);
        }
        if (string2.equals("TRACE")) {
            HttpTrace httpTrace = new HttpTrace(string3);
            return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)var3_4);
        }
        if (string2.equals("OPTIONS")) {
            HttpOptions httpOptions = new HttpOptions(string3);
            return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)var3_4);
        }
        HttpExtensionMethod httpExtensionMethod = new HttpExtensionMethod(string2, string3);
        return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)var3_4);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    @Override
    public boolean supportsMethod(String string2) {
        return true;
    }

    public static final class Builder {
        private HttpParams params;
        private ProxySelector proxySelector;
        private SSLSocketFactory socketFactory = SSLSocketFactory.getSocketFactory();

        public Builder() {
            this.params = ApacheHttpTransport.newDefaultHttpParams();
            this.proxySelector = ProxySelector.getDefault();
        }

        public ApacheHttpTransport build() {
            return new ApacheHttpTransport((HttpClient)ApacheHttpTransport.newDefaultHttpClient(this.socketFactory, this.params, this.proxySelector));
        }

        @Beta
        public Builder doNotValidateCertificate() throws GeneralSecurityException {
            this.socketFactory = new SSLSocketFactoryExtension(SslUtils.trustAllSSLContext());
            this.socketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return this;
        }

        public HttpParams getHttpParams() {
            return this.params;
        }

        public SSLSocketFactory getSSLSocketFactory() {
            return this.socketFactory;
        }

        public Builder setProxy(HttpHost httpHost) {
            ConnRouteParams.setDefaultProxy((HttpParams)this.params, (HttpHost)httpHost);
            if (httpHost != null) {
                this.proxySelector = null;
            }
            return this;
        }

        public Builder setProxySelector(ProxySelector proxySelector) {
            this.proxySelector = proxySelector;
            if (proxySelector != null) {
                ConnRouteParams.setDefaultProxy((HttpParams)this.params, null);
            }
            return this;
        }

        public Builder setSocketFactory(SSLSocketFactory sSLSocketFactory) {
            this.socketFactory = Preconditions.checkNotNull(sSLSocketFactory);
            return this;
        }

        public Builder trustCertificates(KeyStore keyStore) throws GeneralSecurityException {
            SSLContext sSLContext = SslUtils.getTlsSslContext();
            SslUtils.initSslContext(sSLContext, keyStore, SslUtils.getPkixTrustManagerFactory());
            return this.setSocketFactory(new SSLSocketFactoryExtension(sSLContext));
        }

        public Builder trustCertificatesFromJavaKeyStore(InputStream inputStream, String string2) throws GeneralSecurityException, IOException {
            KeyStore keyStore = SecurityUtils.getJavaKeyStore();
            SecurityUtils.loadKeyStore(keyStore, inputStream, string2);
            return this.trustCertificates(keyStore);
        }

        public Builder trustCertificatesFromStream(InputStream inputStream) throws GeneralSecurityException, IOException {
            KeyStore keyStore = SecurityUtils.getJavaKeyStore();
            keyStore.load(null, null);
            SecurityUtils.loadKeyStoreFromCertificates(keyStore, SecurityUtils.getX509CertificateFactory(), inputStream);
            return this.trustCertificates(keyStore);
        }
    }
}

