/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.apache;

import com.google.api.client.http.LowLevelHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpRequestBase;

final class ApacheHttpResponse
extends LowLevelHttpResponse {
    private final Header[] allHeaders;
    private final HttpRequestBase request;
    private final HttpResponse response;

    ApacheHttpResponse(HttpRequestBase httpRequestBase, HttpResponse httpResponse) {
        this.request = httpRequestBase;
        this.response = httpResponse;
        this.allHeaders = httpResponse.getAllHeaders();
    }

    @Override
    public void disconnect() {
        this.request.abort();
    }

    @Override
    public InputStream getContent() throws IOException {
        HttpEntity httpEntity = this.response.getEntity();
        if (httpEntity == null) {
            return null;
        }
        return httpEntity.getContent();
    }

    @Override
    public String getContentEncoding() {
        Header header;
        HttpEntity httpEntity = this.response.getEntity();
        if (httpEntity != null && (header = httpEntity.getContentEncoding()) != null) {
            return header.getValue();
        }
        return null;
    }

    @Override
    public long getContentLength() {
        HttpEntity httpEntity = this.response.getEntity();
        if (httpEntity == null) {
            return -1L;
        }
        return httpEntity.getContentLength();
    }

    @Override
    public String getContentType() {
        Header header;
        HttpEntity httpEntity = this.response.getEntity();
        if (httpEntity != null && (header = httpEntity.getContentType()) != null) {
            return header.getValue();
        }
        return null;
    }

    @Override
    public int getHeaderCount() {
        return this.allHeaders.length;
    }

    @Override
    public String getHeaderName(int n2) {
        return this.allHeaders[n2].getName();
    }

    @Override
    public String getHeaderValue(int n2) {
        return this.allHeaders[n2].getValue();
    }

    public String getHeaderValue(String string2) {
        return this.response.getLastHeader(string2).getValue();
    }

    @Override
    public String getReasonPhrase() {
        StatusLine statusLine = this.response.getStatusLine();
        if (statusLine == null) {
            return null;
        }
        return statusLine.getReasonPhrase();
    }

    @Override
    public int getStatusCode() {
        StatusLine statusLine = this.response.getStatusLine();
        if (statusLine == null) {
            return 0;
        }
        return statusLine.getStatusCode();
    }

    @Override
    public String getStatusLine() {
        StatusLine statusLine = this.response.getStatusLine();
        if (statusLine == null) {
            return null;
        }
        return statusLine.toString();
    }
}

