/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.apache;

import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.http.apache.ApacheHttpResponse;
import com.google.api.client.http.apache.ContentEntity;
import com.google.api.client.util.Preconditions;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

final class ApacheHttpRequest
extends LowLevelHttpRequest {
    private final HttpClient httpClient;
    private final HttpRequestBase request;

    ApacheHttpRequest(HttpClient httpClient, HttpRequestBase httpRequestBase) {
        this.httpClient = httpClient;
        this.request = httpRequestBase;
    }

    @Override
    public void addHeader(String string2, String string3) {
        this.request.addHeader(string2, string3);
    }

    @Override
    public LowLevelHttpResponse execute() throws IOException {
        if (this.getStreamingContent() != null) {
            boolean bl2 = this.request instanceof HttpEntityEnclosingRequest;
            Object[] objectArray = new Object[]{this.request.getRequestLine().getMethod()};
            Preconditions.checkArgument(bl2, "Apache HTTP client does not support %s requests with content.", objectArray);
            ContentEntity contentEntity = new ContentEntity(this.getContentLength(), this.getStreamingContent());
            contentEntity.setContentEncoding(this.getContentEncoding());
            contentEntity.setContentType(this.getContentType());
            ((HttpEntityEnclosingRequest)this.request).setEntity((HttpEntity)contentEntity);
        }
        return new ApacheHttpResponse(this.request, this.httpClient.execute((HttpUriRequest)this.request));
    }

    @Override
    public void setTimeout(int n2, int n3) throws IOException {
        HttpParams httpParams = this.request.getParams();
        ConnManagerParams.setTimeout((HttpParams)httpParams, (long)n2);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)n2);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)n3);
    }
}

