/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.AbstractHttpContent;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.UrlEncodedParser;
import com.google.api.client.util.Data;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Types;
import com.google.api.client.util.escape.CharEscapers;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UrlEncodedContent
extends AbstractHttpContent {
    private Object data;

    public UrlEncodedContent(Object object) {
        super(UrlEncodedParser.MEDIA_TYPE);
        this.setData(object);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean appendParam(boolean bl2, Writer writer, String string2, Object object) throws IOException {
        String string3;
        block6: {
            block5: {
                if (object == null || Data.isNull(object)) break block5;
                if (bl2) {
                    bl2 = false;
                } else {
                    writer.write("&");
                }
                writer.write(string2);
                String string4 = object instanceof Enum ? FieldInfo.of((Enum)object).getName() : object.toString();
                string3 = CharEscapers.escapeUri(string4);
                if (string3.length() != 0) break block6;
            }
            return bl2;
        }
        writer.write("=");
        writer.write(string3);
        return bl2;
    }

    public static UrlEncodedContent getContent(HttpRequest httpRequest) {
        HttpContent httpContent = httpRequest.getContent();
        if (httpContent != null) {
            return (UrlEncodedContent)httpContent;
        }
        UrlEncodedContent urlEncodedContent = new UrlEncodedContent(new HashMap());
        httpRequest.setContent(urlEncodedContent);
        return urlEncodedContent;
    }

    public final Object getData() {
        return this.data;
    }

    public UrlEncodedContent setData(Object object) {
        this.data = Preconditions.checkNotNull(object);
        return this;
    }

    @Override
    public UrlEncodedContent setMediaType(HttpMediaType httpMediaType) {
        super.setMediaType(httpMediaType);
        return this;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, this.getCharset()));
        boolean bl2 = true;
        for (Map.Entry<String, Object> entry : Data.mapOf(this.data).entrySet()) {
            Object object = entry.getValue();
            if (object == null) continue;
            String string2 = CharEscapers.escapeUri(entry.getKey());
            Class<?> clazz = object.getClass();
            if (object instanceof Iterable || clazz.isArray()) {
                Iterator iterator = Types.iterableOf(object).iterator();
                while (iterator.hasNext()) {
                    bl2 = UrlEncodedContent.appendParam(bl2, bufferedWriter, string2, iterator.next());
                }
                continue;
            }
            bl2 = UrlEncodedContent.appendParam(bl2, bufferedWriter, string2, object);
        }
        ((Writer)bufferedWriter).flush();
    }
}

