/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.util.Data;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Types;
import com.google.api.client.util.escape.CharEscapers;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class UriTemplate {
    private static final String COMPOSITE_NON_EXPLODE_JOINER = ",";
    static final Map<Character, CompositeOutput> COMPOSITE_PREFIXES = new HashMap<Character, CompositeOutput>();

    static {
        CompositeOutput.values();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String expand(String string2, Object object, boolean bl2) {
        Map<String, Object> map = UriTemplate.getMap(object);
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = string2.length();
        while (n2 < n3) {
            String string3;
            Object object2;
            int n4 = string2.indexOf(123, n2);
            if (n4 == -1) {
                if (n2 == 0 && !bl2) {
                    return string2;
                }
                stringBuilder.append(string2.substring(n2));
                break;
            }
            stringBuilder.append(string2.substring(n2, n4));
            int n5 = string2.indexOf(125, n4 + 2);
            String string4 = string2.substring(n4 + 1, n5);
            n2 = n5 + 1;
            boolean bl3 = string4.endsWith("*");
            CompositeOutput compositeOutput = UriTemplate.getCompositeOutput(string4);
            int n6 = compositeOutput.getVarNameStartIndex();
            int n7 = string4.length();
            if (bl3) {
                --n7;
            }
            if ((object2 = map.remove(string3 = string4.substring(n6, n7))) == null) continue;
            if (object2 instanceof Iterator) {
                object2 = UriTemplate.getListPropertyValue(string3, (Iterator)object2, bl3, compositeOutput);
            } else if (object2 instanceof Iterable || object2.getClass().isArray()) {
                object2 = UriTemplate.getListPropertyValue(string3, Types.iterableOf(object2).iterator(), bl3, compositeOutput);
            } else if (object2.getClass().isEnum()) {
                String string5 = FieldInfo.of((Enum)object2).getName();
                if (string5 != null) {
                    object2 = CharEscapers.escapeUriPath(string5);
                }
            } else {
                object2 = !Data.isValueOfPrimitiveType(object2) ? UriTemplate.getMapPropertyValue(string3, UriTemplate.getMap(object2), bl3, compositeOutput) : (compositeOutput.getReservedExpansion() ? CharEscapers.escapeUriPathWithoutReserved(object2.toString()) : CharEscapers.escapeUriPath(object2.toString()));
            }
            stringBuilder.append(object2);
        }
        if (bl2) {
            GenericUrl.addQueryParams(map.entrySet(), stringBuilder);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String expand(String string2, String string3, Object object, boolean bl2) {
        String string4;
        if (string3.startsWith("/")) {
            GenericUrl genericUrl = new GenericUrl(string2);
            genericUrl.setRawPath(null);
            string4 = genericUrl.build() + string3;
            return UriTemplate.expand(string4, object, bl2);
        }
        if (string3.startsWith("http://") || string3.startsWith("https://")) {
            string4 = string3;
            return UriTemplate.expand(string4, object, bl2);
        }
        string4 = string2 + string3;
        return UriTemplate.expand(string4, object, bl2);
    }

    static CompositeOutput getCompositeOutput(String string2) {
        CompositeOutput compositeOutput = COMPOSITE_PREFIXES.get(Character.valueOf(string2.charAt(0)));
        if (compositeOutput == null) {
            compositeOutput = CompositeOutput.SIMPLE;
        }
        return compositeOutput;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getListPropertyValue(String string2, Iterator<?> iterator, boolean bl2, CompositeOutput compositeOutput) {
        String string3;
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(compositeOutput.getOutputPrefix());
        if (bl2) {
            string3 = compositeOutput.getExplodeJoiner();
        } else {
            string3 = COMPOSITE_NON_EXPLODE_JOINER;
            if (compositeOutput.requiresVarAssignment()) {
                stringBuilder.append(CharEscapers.escapeUriPath(string2));
                stringBuilder.append("=");
            }
        }
        while (iterator.hasNext()) {
            if (bl2 && compositeOutput.requiresVarAssignment()) {
                stringBuilder.append(CharEscapers.escapeUriPath(string2));
                stringBuilder.append("=");
            }
            stringBuilder.append(compositeOutput.getEncodedValue(iterator.next().toString()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    private static Map<String, Object> getMap(Object object) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : Data.mapOf(object).entrySet()) {
            Object object2 = entry.getValue();
            if (object2 == null || Data.isNull(object2)) continue;
            linkedHashMap.put(entry.getKey(), object2);
        }
        return linkedHashMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getMapPropertyValue(String string2, Map<String, Object> map, boolean bl2, CompositeOutput compositeOutput) {
        String string3;
        String string4;
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(compositeOutput.getOutputPrefix());
        if (bl2) {
            string4 = compositeOutput.getExplodeJoiner();
            string3 = "=";
        } else {
            string4 = COMPOSITE_NON_EXPLODE_JOINER;
            string3 = COMPOSITE_NON_EXPLODE_JOINER;
            if (compositeOutput.requiresVarAssignment()) {
                stringBuilder.append(CharEscapers.escapeUriPath(string2));
                stringBuilder.append("=");
            }
        }
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String string5 = compositeOutput.getEncodedValue(entry.getKey());
            String string6 = compositeOutput.getEncodedValue(entry.getValue().toString());
            stringBuilder.append(string5);
            stringBuilder.append(string3);
            stringBuilder.append(string6);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    private static final class CompositeOutput
    extends Enum<CompositeOutput> {
        private static final /* synthetic */ CompositeOutput[] $VALUES;
        public static final /* enum */ CompositeOutput AMP;
        public static final /* enum */ CompositeOutput DOT;
        public static final /* enum */ CompositeOutput FORWARD_SLASH;
        public static final /* enum */ CompositeOutput HASH;
        public static final /* enum */ CompositeOutput PLUS;
        public static final /* enum */ CompositeOutput QUERY;
        public static final /* enum */ CompositeOutput SEMI_COLON;
        public static final /* enum */ CompositeOutput SIMPLE;
        private final String explodeJoiner;
        private final String outputPrefix;
        private final Character propertyPrefix;
        private final boolean requiresVarAssignment;
        private final boolean reservedExpansion;

        static {
            PLUS = new CompositeOutput(Character.valueOf('+'), "", UriTemplate.COMPOSITE_NON_EXPLODE_JOINER, false, true);
            HASH = new CompositeOutput(Character.valueOf('#'), "#", UriTemplate.COMPOSITE_NON_EXPLODE_JOINER, false, true);
            DOT = new CompositeOutput(Character.valueOf('.'), ".", ".", false, false);
            FORWARD_SLASH = new CompositeOutput(Character.valueOf('/'), "/", "/", false, false);
            SEMI_COLON = new CompositeOutput(Character.valueOf(';'), ";", ";", true, false);
            QUERY = new CompositeOutput(Character.valueOf('?'), "?", "&", true, false);
            AMP = new CompositeOutput(Character.valueOf('&'), "&", "&", true, false);
            SIMPLE = new CompositeOutput(null, "", UriTemplate.COMPOSITE_NON_EXPLODE_JOINER, false, false);
            CompositeOutput[] compositeOutputArray = new CompositeOutput[]{PLUS, HASH, DOT, FORWARD_SLASH, SEMI_COLON, QUERY, AMP, SIMPLE};
            $VALUES = compositeOutputArray;
        }

        private CompositeOutput(Character c2, String string3, String string4, boolean bl2, boolean bl3) {
            this.propertyPrefix = c2;
            this.outputPrefix = Preconditions.checkNotNull(string3);
            this.explodeJoiner = Preconditions.checkNotNull(string4);
            this.requiresVarAssignment = bl2;
            this.reservedExpansion = bl3;
            if (c2 != null) {
                COMPOSITE_PREFIXES.put(c2, this);
            }
        }

        public static CompositeOutput valueOf(String string2) {
            return Enum.valueOf(CompositeOutput.class, string2);
        }

        public static CompositeOutput[] values() {
            return (CompositeOutput[])$VALUES.clone();
        }

        String getEncodedValue(String string2) {
            if (this.reservedExpansion) {
                return CharEscapers.escapeUriPath(string2);
            }
            return CharEscapers.escapeUri(string2);
        }

        String getExplodeJoiner() {
            return this.explodeJoiner;
        }

        String getOutputPrefix() {
            return this.outputPrefix;
        }

        boolean getReservedExpansion() {
            return this.reservedExpansion;
        }

        int getVarNameStartIndex() {
            if (this.propertyPrefix == null) {
                return 0;
            }
            return 1;
        }

        boolean requiresVarAssignment() {
            return this.requiresVarAssignment;
        }
    }
}

