/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.AbstractHttpContent;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpEncoding;
import com.google.api.client.http.HttpEncodingStreamingContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.StreamingContent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class MultipartContent
extends AbstractHttpContent {
    static final String NEWLINE = "\r\n";
    private static final String TWO_DASHES = "--";
    private ArrayList<Part> parts = new ArrayList();

    public MultipartContent() {
        super(new HttpMediaType("multipart/related").setParameter("boundary", "__END_OF_PART__"));
    }

    public MultipartContent addPart(Part part) {
        this.parts.add(Preconditions.checkNotNull(part));
        return this;
    }

    public final String getBoundary() {
        return this.getMediaType().getParameter("boundary");
    }

    public final Collection<Part> getParts() {
        return Collections.unmodifiableCollection(this.parts);
    }

    @Override
    public boolean retrySupported() {
        Iterator<Part> iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().content.retrySupported()) continue;
            return false;
        }
        return true;
    }

    public MultipartContent setBoundary(String string2) {
        this.getMediaType().setParameter("boundary", Preconditions.checkNotNull(string2));
        return this;
    }

    public MultipartContent setContentParts(Collection<? extends HttpContent> collection) {
        this.parts = new ArrayList(collection.size());
        Iterator<? extends HttpContent> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addPart(new Part(iterator.next()));
        }
        return this;
    }

    @Override
    public MultipartContent setMediaType(HttpMediaType httpMediaType) {
        super.setMediaType(httpMediaType);
        return this;
    }

    public MultipartContent setParts(Collection<Part> collection) {
        this.parts = new ArrayList<Part>(collection);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.getCharset());
        String string2 = this.getBoundary();
        Iterator<Part> iterator = this.parts.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                outputStreamWriter.write(TWO_DASHES);
                outputStreamWriter.write(string2);
                outputStreamWriter.write(TWO_DASHES);
                outputStreamWriter.write(NEWLINE);
                ((Writer)outputStreamWriter).flush();
                return;
            }
            Part part = iterator.next();
            HttpHeaders httpHeaders = new HttpHeaders().setAcceptEncoding(null);
            if (part.headers != null) {
                httpHeaders.fromHttpHeaders(part.headers);
            }
            httpHeaders.setContentEncoding(null).setUserAgent(null).setContentType(null).setContentLength(null).set("Content-Transfer-Encoding", null);
            HttpContent httpContent = part.content;
            StreamingContent streamingContent = null;
            if (httpContent != null) {
                long l2;
                httpHeaders.set("Content-Transfer-Encoding", Arrays.asList("binary"));
                httpHeaders.setContentType(httpContent.getType());
                HttpEncoding httpEncoding = part.encoding;
                if (httpEncoding == null) {
                    l2 = httpContent.getLength();
                    streamingContent = httpContent;
                } else {
                    httpHeaders.setContentEncoding(httpEncoding.getName());
                    streamingContent = new HttpEncodingStreamingContent(httpContent, httpEncoding);
                    l2 = AbstractHttpContent.computeLength(httpContent);
                }
                if (l2 != -1L) {
                    httpHeaders.setContentLength(l2);
                }
            }
            outputStreamWriter.write(TWO_DASHES);
            outputStreamWriter.write(string2);
            outputStreamWriter.write(NEWLINE);
            HttpHeaders.serializeHeadersForMultipartRequests(httpHeaders, null, null, outputStreamWriter);
            if (streamingContent == null) continue;
            outputStreamWriter.write(NEWLINE);
            ((Writer)outputStreamWriter).flush();
            streamingContent.writeTo(outputStream);
            outputStreamWriter.write(NEWLINE);
        }
    }

    public static final class Part {
        HttpContent content;
        HttpEncoding encoding;
        HttpHeaders headers;

        public Part() {
            this(null);
        }

        public Part(HttpContent httpContent) {
            this(null, httpContent);
        }

        public Part(HttpHeaders httpHeaders, HttpContent httpContent) {
            this.setHeaders(httpHeaders);
            this.setContent(httpContent);
        }

        public HttpContent getContent() {
            return this.content;
        }

        public HttpEncoding getEncoding() {
            return this.encoding;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public Part setContent(HttpContent httpContent) {
            this.content = httpContent;
            return this;
        }

        public Part setEncoding(HttpEncoding httpEncoding) {
            this.encoding = httpEncoding;
            return this;
        }

        public Part setHeaders(HttpHeaders httpHeaders) {
            this.headers = httpHeaders;
            return this;
        }
    }
}

