/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpStatusCodes;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.StringUtils;
import java.io.IOException;

public class HttpResponseException
extends IOException {
    private static final long serialVersionUID = -1875819453475890043L;
    private final String content;
    private final transient HttpHeaders headers;
    private final int statusCode;
    private final String statusMessage;

    public HttpResponseException(HttpResponse httpResponse) {
        this(new Builder(httpResponse));
    }

    protected HttpResponseException(Builder builder) {
        super(builder.message);
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.headers = builder.headers;
        this.content = builder.content;
    }

    public static StringBuilder computeMessageBuffer(HttpResponse httpResponse) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = httpResponse.getStatusCode();
        if (n2 != 0) {
            stringBuilder.append(n2);
        }
        if ((string2 = httpResponse.getStatusMessage()) != null) {
            if (n2 != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder;
    }

    public final String getContent() {
        return this.content;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final String getStatusMessage() {
        return this.statusMessage;
    }

    public final boolean isSuccessStatusCode() {
        return HttpStatusCodes.isSuccess(this.statusCode);
    }

    public static class Builder {
        String content;
        HttpHeaders headers;
        String message;
        int statusCode;
        String statusMessage;

        public Builder(int n2, String string2, HttpHeaders httpHeaders) {
            this.setStatusCode(n2);
            this.setStatusMessage(string2);
            this.setHeaders(httpHeaders);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Builder(HttpResponse httpResponse) {
            this(httpResponse.getStatusCode(), httpResponse.getStatusMessage(), httpResponse.getHeaders());
            try {
                this.content = httpResponse.parseAsString();
                if (this.content.length() == 0) {
                    this.content = null;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            StringBuilder stringBuilder = HttpResponseException.computeMessageBuffer(httpResponse);
            if (this.content != null) {
                stringBuilder.append(StringUtils.LINE_SEPARATOR).append(this.content);
            }
            this.message = stringBuilder.toString();
        }

        public HttpResponseException build() {
            return new HttpResponseException(this);
        }

        public final String getContent() {
            return this.content;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public final String getMessage() {
            return this.message;
        }

        public final int getStatusCode() {
            return this.statusCode;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public Builder setContent(String string2) {
            this.content = string2;
            return this;
        }

        public Builder setHeaders(HttpHeaders httpHeaders) {
            this.headers = Preconditions.checkNotNull(httpHeaders);
            return this;
        }

        public Builder setMessage(String string2) {
            this.message = string2;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder setStatusCode(int n2) {
            boolean bl2 = n2 >= 0;
            Preconditions.checkArgument(bl2);
            this.statusCode = n2;
            return this;
        }

        public Builder setStatusMessage(String string2) {
            this.statusMessage = string2;
            return this;
        }
    }
}

