/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpStatusCodes;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.util.Charsets;
import com.google.api.client.util.IOUtils;
import com.google.api.client.util.LoggingInputStream;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public final class HttpResponse {
    private InputStream content;
    private final String contentEncoding;
    private int contentLoggingLimit;
    private boolean contentRead;
    private final String contentType;
    private boolean loggingEnabled;
    private final HttpMediaType mediaType;
    private final HttpRequest request;
    LowLevelHttpResponse response;
    private final int statusCode;
    private final String statusMessage;

    /*
     * Enabled aggressive block sorting
     */
    HttpResponse(HttpRequest httpRequest, LowLevelHttpResponse lowLevelHttpResponse) throws IOException {
        String string2;
        this.request = httpRequest;
        this.contentLoggingLimit = httpRequest.getContentLoggingLimit();
        this.loggingEnabled = httpRequest.isLoggingEnabled();
        this.response = lowLevelHttpResponse;
        this.contentEncoding = lowLevelHttpResponse.getContentEncoding();
        int n2 = lowLevelHttpResponse.getStatusCode();
        if (n2 < 0) {
            n2 = 0;
        }
        this.statusCode = n2;
        this.statusMessage = string2 = lowLevelHttpResponse.getReasonPhrase();
        Logger logger = HttpTransport.LOGGER;
        boolean bl2 = this.loggingEnabled && logger.isLoggable(Level.CONFIG);
        StringBuilder stringBuilder = null;
        if (bl2) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("-------------- RESPONSE --------------").append(StringUtils.LINE_SEPARATOR);
            String string3 = lowLevelHttpResponse.getStatusLine();
            if (string3 != null) {
                stringBuilder.append(string3);
            } else {
                stringBuilder.append(this.statusCode);
                if (string2 != null) {
                    stringBuilder.append(' ').append(string2);
                }
            }
            stringBuilder.append(StringUtils.LINE_SEPARATOR);
        }
        HttpHeaders httpHeaders = httpRequest.getResponseHeaders();
        StringBuilder stringBuilder2 = bl2 ? stringBuilder : null;
        httpHeaders.fromHttpResponse(lowLevelHttpResponse, stringBuilder2);
        String string4 = lowLevelHttpResponse.getContentType();
        if (string4 == null) {
            string4 = httpRequest.getResponseHeaders().getContentType();
        }
        this.contentType = string4;
        HttpMediaType httpMediaType = null;
        if (string4 != null) {
            httpMediaType = new HttpMediaType(string4);
        }
        this.mediaType = httpMediaType;
        if (bl2) {
            logger.config(stringBuilder.toString());
        }
    }

    private boolean hasMessageBody() throws IOException {
        boolean bl2 = true;
        int n2 = this.getStatusCode();
        if (this.getRequest().getRequestMethod().equals("HEAD") || n2 / 100 == bl2 || n2 == 204 || n2 == 304) {
            this.ignore();
            bl2 = false;
        }
        return bl2;
    }

    public void disconnect() throws IOException {
        this.ignore();
        this.response.disconnect();
    }

    public void download(OutputStream outputStream) throws IOException {
        IOUtils.copy(this.getContent(), outputStream);
    }

    /*
     * Unable to fully structure code
     */
    public InputStream getContent() throws IOException {
        block14: {
            if (this.contentRead) ** GOTO lbl23
            var1_1 = this.response.getContent();
            if (var1_1 == null) ** GOTO lbl20
            var4_2 = this.contentEncoding;
            if (var4_2 == null) break block14;
            if (!var4_2.contains("gzip")) break block14;
            var5_3 = new GZIPInputStream(var1_1);
lbl10:
            // 2 sources

            while (true) {
                block15: {
                    try {
                        var7_4 = HttpTransport.LOGGER;
                        if (!this.loggingEnabled || !var7_4.isLoggable(Level.CONFIG)) break block15;
                        var1_1 = new LoggingInputStream(var5_3, var7_4, Level.CONFIG, this.contentLoggingLimit);
                    }
                    catch (Throwable var2_8) {
                        var1_1 = var5_3;
                        ** continue;
                    }
                    catch (EOFException var6_9) {
                        var1_1 = var5_3;
                        ** continue;
                    }
lbl15:
                    // 2 sources

                    while (true) {
                        block16: {
                            try {
                                this.content = var1_1;
                                if (true) break block16;
                            }
                            catch (EOFException var3_5) lbl-1000:
                            // 2 sources

                            {
                                while (true) {
                                    if (false) ** GOTO lbl21
                                    var1_1.close();
                                    ** continue;
                                    break;
                                }
                            }
                            catch (Throwable var2_6) lbl-1000:
                            // 2 sources

                            {
                                while (true) {
                                    if (!false) {
                                        var1_1.close();
                                    }
                                    throw var2_7;
                                }
                            }
                            var1_1.close();
                        }
lbl21:
                        // 3 sources

                        while (true) {
                            this.contentRead = true;
lbl23:
                            // 2 sources

                            return this.content;
                        }
                        break;
                    }
                }
                var1_1 = var5_3;
                ** continue;
                break;
            }
        }
        var5_3 = var1_1;
        ** while (true)
    }

    public Charset getContentCharset() {
        if (this.mediaType == null || this.mediaType.getCharsetParameter() == null) {
            return Charsets.ISO_8859_1;
        }
        return this.mediaType.getCharsetParameter();
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public int getContentLoggingLimit() {
        return this.contentLoggingLimit;
    }

    public String getContentType() {
        return this.contentType;
    }

    public HttpHeaders getHeaders() {
        return this.request.getResponseHeaders();
    }

    public HttpMediaType getMediaType() {
        return this.mediaType;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public HttpTransport getTransport() {
        return this.request.getTransport();
    }

    public void ignore() throws IOException {
        InputStream inputStream = this.getContent();
        if (inputStream != null) {
            inputStream.close();
        }
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public boolean isSuccessStatusCode() {
        return HttpStatusCodes.isSuccess(this.statusCode);
    }

    public <T> T parseAs(Class<T> clazz) throws IOException {
        if (!this.hasMessageBody()) {
            return null;
        }
        return this.request.getParser().parseAndClose(this.getContent(), this.getContentCharset(), clazz);
    }

    public Object parseAs(Type type) throws IOException {
        if (!this.hasMessageBody()) {
            return null;
        }
        return this.request.getParser().parseAndClose(this.getContent(), this.getContentCharset(), type);
    }

    public String parseAsString() throws IOException {
        InputStream inputStream = this.getContent();
        if (inputStream == null) {
            return "";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toString(this.getContentCharset().name());
    }

    /*
     * Enabled aggressive block sorting
     */
    public HttpResponse setContentLoggingLimit(int n2) {
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2, "The content logging limit must be non-negative.");
        this.contentLoggingLimit = n2;
        return this;
    }

    public HttpResponse setLoggingEnabled(boolean bl2) {
        this.loggingEnabled = bl2;
        return this;
    }
}

