/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.BackOffPolicy;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpEncoding;
import com.google.api.client.http.HttpEncodingStreamingContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpStatusCodes;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.util.Beta;
import com.google.api.client.util.IOUtils;
import com.google.api.client.util.LoggingStreamingContent;
import com.google.api.client.util.ObjectParser;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Sleeper;
import com.google.api.client.util.StreamingContent;
import com.google.api.client.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HttpRequest {
    public static final String USER_AGENT_SUFFIX = "Google-HTTP-Java-Client/1.18.0-rc (gzip)";
    public static final String VERSION = "1.18.0-rc";
    @Deprecated
    @Beta
    private BackOffPolicy backOffPolicy;
    private int connectTimeout = 20000;
    private HttpContent content;
    private int contentLoggingLimit = 16384;
    private boolean curlLoggingEnabled = true;
    private HttpEncoding encoding;
    private HttpExecuteInterceptor executeInterceptor;
    private boolean followRedirects = true;
    private HttpHeaders headers = new HttpHeaders();
    @Beta
    private HttpIOExceptionHandler ioExceptionHandler;
    private boolean loggingEnabled = true;
    private int numRetries = 10;
    private ObjectParser objectParser;
    private int readTimeout = 20000;
    private String requestMethod;
    private HttpHeaders responseHeaders = new HttpHeaders();
    private HttpResponseInterceptor responseInterceptor;
    @Deprecated
    @Beta
    private boolean retryOnExecuteIOException = false;
    private Sleeper sleeper = Sleeper.DEFAULT;
    private boolean suppressUserAgentSuffix;
    private boolean throwExceptionOnExecuteError = true;
    private final HttpTransport transport;
    private HttpUnsuccessfulResponseHandler unsuccessfulResponseHandler;
    private GenericUrl url;

    HttpRequest(HttpTransport httpTransport, String string2) {
        this.transport = httpTransport;
        this.setRequestMethod(string2);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpResponse execute() throws IOException {
        Object var6_4;
        boolean bl2;
        boolean bl3 = this.numRetries >= 0;
        Preconditions.checkArgument(bl3);
        int n2 = this.numRetries;
        if (this.backOffPolicy != null) {
            this.backOffPolicy.reset();
        }
        HttpResponse httpResponse = null;
        Preconditions.checkNotNull(this.requestMethod);
        Preconditions.checkNotNull(this.url);
        do {
            block49: {
                boolean bl4;
                boolean bl5;
                block47: {
                    block48: {
                        block46: {
                            StreamingContent streamingContent;
                            if (httpResponse != null) {
                                httpResponse.ignore();
                            }
                            httpResponse = null;
                            var6_4 = null;
                            if (this.executeInterceptor != null) {
                                this.executeInterceptor.intercept(this);
                            }
                            String string2 = this.url.build();
                            LowLevelHttpRequest lowLevelHttpRequest = this.transport.buildRequest(this.requestMethod, string2);
                            Logger logger = HttpTransport.LOGGER;
                            boolean bl6 = this.loggingEnabled && logger.isLoggable(Level.CONFIG);
                            StringBuilder stringBuilder = null;
                            StringBuilder stringBuilder2 = null;
                            if (bl6) {
                                stringBuilder2 = new StringBuilder();
                                stringBuilder2.append("-------------- REQUEST  --------------").append(StringUtils.LINE_SEPARATOR);
                                String string3 = this.requestMethod;
                                stringBuilder2.append(string3).append(' ').append(string2).append(StringUtils.LINE_SEPARATOR);
                                boolean bl7 = this.curlLoggingEnabled;
                                stringBuilder = null;
                                if (bl7) {
                                    stringBuilder = new StringBuilder("curl -v --compressed");
                                    if (!this.requestMethod.equals("GET")) {
                                        stringBuilder.append(" -X ").append(this.requestMethod);
                                    }
                                }
                            }
                            String string4 = this.headers.getUserAgent();
                            if (!this.suppressUserAgentSuffix) {
                                if (string4 == null) {
                                    this.headers.setUserAgent(USER_AGENT_SUFFIX);
                                } else {
                                    this.headers.setUserAgent(string4 + " " + USER_AGENT_SUFFIX);
                                }
                            }
                            HttpHeaders.serializeHeaders(this.headers, stringBuilder2, stringBuilder, logger, lowLevelHttpRequest);
                            if (!this.suppressUserAgentSuffix) {
                                this.headers.setUserAgent(string4);
                            }
                            boolean bl8 = (streamingContent = this.content) == null || this.content.retrySupported();
                            if (streamingContent != null) {
                                long l2;
                                String string5;
                                String string6 = this.content.getType();
                                if (bl6) {
                                    Logger logger2 = HttpTransport.LOGGER;
                                    Level level = Level.CONFIG;
                                    int n3 = this.contentLoggingLimit;
                                    LoggingStreamingContent loggingStreamingContent = new LoggingStreamingContent(streamingContent, logger2, level, n3);
                                    streamingContent = loggingStreamingContent;
                                }
                                if (this.encoding == null) {
                                    string5 = null;
                                    l2 = this.content.getLength();
                                } else {
                                    string5 = this.encoding.getName();
                                    HttpEncoding httpEncoding = this.encoding;
                                    HttpEncodingStreamingContent httpEncodingStreamingContent = new HttpEncodingStreamingContent(streamingContent, httpEncoding);
                                    l2 = bl8 ? IOUtils.computeLength(httpEncodingStreamingContent) : -1L;
                                    streamingContent = httpEncodingStreamingContent;
                                }
                                if (bl6) {
                                    if (string6 != null) {
                                        String string7 = "Content-Type: " + string6;
                                        stringBuilder2.append(string7).append(StringUtils.LINE_SEPARATOR);
                                        if (stringBuilder != null) {
                                            stringBuilder.append(" -H '" + string7 + "'");
                                        }
                                    }
                                    if (l2 >= 0L) {
                                        String string8 = "Content-Length: " + l2;
                                        stringBuilder2.append(string8).append(StringUtils.LINE_SEPARATOR);
                                    }
                                }
                                if (stringBuilder != null) {
                                    stringBuilder.append(" -d '@-'");
                                }
                                lowLevelHttpRequest.setContentType(string6);
                                lowLevelHttpRequest.setContentEncoding(string5);
                                lowLevelHttpRequest.setContentLength(l2);
                                lowLevelHttpRequest.setStreamingContent(streamingContent);
                            }
                            if (bl6) {
                                logger.config(stringBuilder2.toString());
                                if (stringBuilder != null) {
                                    stringBuilder.append(" -- '");
                                    stringBuilder.append(string2.replaceAll("'", "'\"'\"'"));
                                    stringBuilder.append("'");
                                    if (streamingContent != null) {
                                        stringBuilder.append(" << $$$");
                                    }
                                    logger.config(stringBuilder.toString());
                                }
                            }
                            bl5 = bl8 && n2 > 0;
                            lowLevelHttpRequest.setTimeout(this.connectTimeout, this.readTimeout);
                            LowLevelHttpResponse lowLevelHttpResponse = lowLevelHttpRequest.execute();
                            try {
                                HttpResponse httpResponse2;
                                httpResponse = httpResponse2 = new HttpResponse(this, lowLevelHttpResponse);
                            }
                            catch (Throwable throwable) {
                                try {
                                    InputStream inputStream = lowLevelHttpResponse.getContent();
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                    throw throwable;
                                }
                                catch (IOException iOException) {
                                    void var21_17;
                                    if (!(this.retryOnExecuteIOException || this.ioExceptionHandler != null && this.ioExceptionHandler.handleIOException(this, bl5))) {
                                        throw var21_17;
                                    }
                                    var6_4 = var21_17;
                                    logger.log(Level.WARNING, "exception thrown while executing request", (Throwable)var21_17);
                                }
                            }
                            if (httpResponse != null) {
                                long l3;
                                if (httpResponse.isSuccessStatusCode()) break block46;
                                HttpUnsuccessfulResponseHandler httpUnsuccessfulResponseHandler = this.unsuccessfulResponseHandler;
                                bl4 = false;
                                if (httpUnsuccessfulResponseHandler != null) {
                                    bl4 = this.unsuccessfulResponseHandler.handleResponse(this, httpResponse, bl5);
                                }
                                if (bl4) break block47;
                                if (this.handleRedirect(httpResponse.getStatusCode(), httpResponse.getHeaders())) {
                                    bl4 = true;
                                    break block47;
                                }
                                if (!bl5 || this.backOffPolicy == null || !this.backOffPolicy.isBackOffRequired(httpResponse.getStatusCode()) || (l3 = this.backOffPolicy.getNextBackOffMillis()) == -1L) break block47;
                                this.sleeper.sleep(l3);
                                break block48;
                            }
                        }
                        boolean bl9 = httpResponse == null;
                        bl2 = bl5 & bl9;
                        break block49;
                        catch (Throwable throwable) {
                            if (httpResponse != null) {
                                httpResponse.disconnect();
                            }
                            throw throwable;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    bl4 = true;
                }
                if (bl2 = bl5 & bl4) {
                    httpResponse.ignore();
                }
            }
            --n2;
            if (httpResponse == null) continue;
        } while (bl2);
        if (httpResponse == null) {
            throw var6_4;
        }
        if (this.responseInterceptor != null) {
            this.responseInterceptor.interceptResponse(httpResponse);
        }
        if (this.throwExceptionOnExecuteError && !httpResponse.isSuccessStatusCode()) {
            try {
                HttpResponseException httpResponseException = new HttpResponseException(httpResponse);
                throw httpResponseException;
            }
            catch (Throwable throwable) {
                httpResponse.disconnect();
                throw throwable;
            }
        }
        return httpResponse;
    }

    @Beta
    public Future<HttpResponse> executeAsync() {
        return this.executeAsync(Executors.newSingleThreadExecutor());
    }

    @Beta
    public Future<HttpResponse> executeAsync(Executor executor) {
        FutureTask<HttpResponse> futureTask = new FutureTask<HttpResponse>(new Callable<HttpResponse>(){

            @Override
            public HttpResponse call() throws Exception {
                return HttpRequest.this.execute();
            }
        });
        executor.execute(futureTask);
        return futureTask;
    }

    @Deprecated
    @Beta
    public BackOffPolicy getBackOffPolicy() {
        return this.backOffPolicy;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public HttpContent getContent() {
        return this.content;
    }

    public int getContentLoggingLimit() {
        return this.contentLoggingLimit;
    }

    public HttpEncoding getEncoding() {
        return this.encoding;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Beta
    public HttpIOExceptionHandler getIOExceptionHandler() {
        return this.ioExceptionHandler;
    }

    public HttpExecuteInterceptor getInterceptor() {
        return this.executeInterceptor;
    }

    public int getNumberOfRetries() {
        return this.numRetries;
    }

    public final ObjectParser getParser() {
        return this.objectParser;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public HttpHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public HttpResponseInterceptor getResponseInterceptor() {
        return this.responseInterceptor;
    }

    @Deprecated
    @Beta
    public boolean getRetryOnExecuteIOException() {
        return this.retryOnExecuteIOException;
    }

    public Sleeper getSleeper() {
        return this.sleeper;
    }

    public boolean getSuppressUserAgentSuffix() {
        return this.suppressUserAgentSuffix;
    }

    public boolean getThrowExceptionOnExecuteError() {
        return this.throwExceptionOnExecuteError;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public HttpUnsuccessfulResponseHandler getUnsuccessfulResponseHandler() {
        return this.unsuccessfulResponseHandler;
    }

    public GenericUrl getUrl() {
        return this.url;
    }

    public boolean handleRedirect(int n2, HttpHeaders httpHeaders) {
        String string2 = httpHeaders.getLocation();
        if (this.getFollowRedirects() && HttpStatusCodes.isRedirect(n2) && string2 != null) {
            this.setUrl(new GenericUrl(this.url.toURL(string2)));
            if (n2 == 303) {
                this.setRequestMethod("GET");
                this.setContent(null);
            }
            this.headers.setAuthorization((String)null);
            this.headers.setIfMatch(null);
            this.headers.setIfNoneMatch(null);
            this.headers.setIfModifiedSince(null);
            this.headers.setIfUnmodifiedSince(null);
            this.headers.setIfRange(null);
            return true;
        }
        return false;
    }

    public boolean isCurlLoggingEnabled() {
        return this.curlLoggingEnabled;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    @Deprecated
    @Beta
    public HttpRequest setBackOffPolicy(BackOffPolicy backOffPolicy) {
        this.backOffPolicy = backOffPolicy;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public HttpRequest setConnectTimeout(int n2) {
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2);
        this.connectTimeout = n2;
        return this;
    }

    public HttpRequest setContent(HttpContent httpContent) {
        this.content = httpContent;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public HttpRequest setContentLoggingLimit(int n2) {
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2, "The content logging limit must be non-negative.");
        this.contentLoggingLimit = n2;
        return this;
    }

    public HttpRequest setCurlLoggingEnabled(boolean bl2) {
        this.curlLoggingEnabled = bl2;
        return this;
    }

    public HttpRequest setEncoding(HttpEncoding httpEncoding) {
        this.encoding = httpEncoding;
        return this;
    }

    public HttpRequest setFollowRedirects(boolean bl2) {
        this.followRedirects = bl2;
        return this;
    }

    public HttpRequest setHeaders(HttpHeaders httpHeaders) {
        this.headers = Preconditions.checkNotNull(httpHeaders);
        return this;
    }

    @Beta
    public HttpRequest setIOExceptionHandler(HttpIOExceptionHandler httpIOExceptionHandler) {
        this.ioExceptionHandler = httpIOExceptionHandler;
        return this;
    }

    public HttpRequest setInterceptor(HttpExecuteInterceptor httpExecuteInterceptor) {
        this.executeInterceptor = httpExecuteInterceptor;
        return this;
    }

    public HttpRequest setLoggingEnabled(boolean bl2) {
        this.loggingEnabled = bl2;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public HttpRequest setNumberOfRetries(int n2) {
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2);
        this.numRetries = n2;
        return this;
    }

    public HttpRequest setParser(ObjectParser objectParser) {
        this.objectParser = objectParser;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public HttpRequest setReadTimeout(int n2) {
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2);
        this.readTimeout = n2;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public HttpRequest setRequestMethod(String string2) {
        boolean bl2 = string2 == null || HttpMediaType.matchesToken(string2);
        Preconditions.checkArgument(bl2);
        this.requestMethod = string2;
        return this;
    }

    public HttpRequest setResponseHeaders(HttpHeaders httpHeaders) {
        this.responseHeaders = Preconditions.checkNotNull(httpHeaders);
        return this;
    }

    public HttpRequest setResponseInterceptor(HttpResponseInterceptor httpResponseInterceptor) {
        this.responseInterceptor = httpResponseInterceptor;
        return this;
    }

    @Deprecated
    @Beta
    public HttpRequest setRetryOnExecuteIOException(boolean bl2) {
        this.retryOnExecuteIOException = bl2;
        return this;
    }

    public HttpRequest setSleeper(Sleeper sleeper) {
        this.sleeper = Preconditions.checkNotNull(sleeper);
        return this;
    }

    public HttpRequest setSuppressUserAgentSuffix(boolean bl2) {
        this.suppressUserAgentSuffix = bl2;
        return this;
    }

    public HttpRequest setThrowExceptionOnExecuteError(boolean bl2) {
        this.throwExceptionOnExecuteError = bl2;
        return this;
    }

    public HttpRequest setUnsuccessfulResponseHandler(HttpUnsuccessfulResponseHandler httpUnsuccessfulResponseHandler) {
        this.unsuccessfulResponseHandler = httpUnsuccessfulResponseHandler;
        return this;
    }

    public HttpRequest setUrl(GenericUrl genericUrl) {
        this.url = Preconditions.checkNotNull(genericUrl);
        return this;
    }
}

