/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.util.Preconditions;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HttpMediaType {
    private static final Pattern FULL_MEDIA_TYPE_REGEX;
    private static final Pattern PARAMETER_REGEX;
    private static final Pattern TOKEN_REGEX;
    private static final Pattern TYPE_REGEX;
    private String cachedBuildResult;
    private final SortedMap<String, String> parameters = new TreeMap<String, String>();
    private String subType = "octet-stream";
    private String type = "application";

    static {
        TYPE_REGEX = Pattern.compile("[\\w!#$&.+\\-\\^_]+|[*]");
        TOKEN_REGEX = Pattern.compile("[\\p{ASCII}&&[^\\p{Cntrl} ;/=\\[\\]\\(\\)\\<\\>\\@\\,\\:\\\"\\?\\=]]+");
        FULL_MEDIA_TYPE_REGEX = Pattern.compile("\\s*(" + "[^\\s/=;\"]+" + ")/(" + "[^\\s/=;\"]+" + ")" + "\\s*(" + ";.*" + ")?", 32);
        String string2 = "\"([^\"]*)\"" + "|" + "[^\\s;\"]*";
        PARAMETER_REGEX = Pattern.compile("\\s*;\\s*(" + "[^\\s/=;\"]+" + ")" + "=(" + string2 + ")");
    }

    public HttpMediaType(String string2) {
        this.fromString(string2);
    }

    public HttpMediaType(String string2, String string3) {
        this.setType(string2);
        this.setSubType(string3);
    }

    public static boolean equalsIgnoreParameters(String string2, String string3) {
        return string2 == null && string3 == null || string2 != null && string3 != null && new HttpMediaType(string2).equalsIgnoreParameters(new HttpMediaType(string3));
    }

    private HttpMediaType fromString(String string2) {
        Matcher matcher = FULL_MEDIA_TYPE_REGEX.matcher(string2);
        Preconditions.checkArgument(matcher.matches(), "Type must be in the 'maintype/subtype; parameter=value' format");
        this.setType(matcher.group(1));
        this.setSubType(matcher.group(2));
        String string3 = matcher.group(3);
        if (string3 != null) {
            Matcher matcher2 = PARAMETER_REGEX.matcher(string3);
            while (matcher2.find()) {
                String string4 = matcher2.group(1);
                String string5 = matcher2.group(3);
                if (string5 == null) {
                    string5 = matcher2.group(2);
                }
                this.setParameter(string4, string5);
            }
        }
        return this;
    }

    static boolean matchesToken(String string2) {
        return TOKEN_REGEX.matcher(string2).matches();
    }

    private static String quoteString(String string2) {
        String string3 = string2.replace("\\", "\\\\").replace("\"", "\\\"");
        return "\"" + string3 + "\"";
    }

    public String build() {
        if (this.cachedBuildResult != null) {
            return this.cachedBuildResult;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.type);
        stringBuilder.append('/');
        stringBuilder.append(this.subType);
        if (this.parameters != null) {
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                String string2 = entry.getValue();
                stringBuilder.append("; ");
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=");
                if (!HttpMediaType.matchesToken(string2)) {
                    string2 = HttpMediaType.quoteString(string2);
                }
                stringBuilder.append(string2);
            }
        }
        this.cachedBuildResult = stringBuilder.toString();
        return this.cachedBuildResult;
    }

    public void clearParameters() {
        this.cachedBuildResult = null;
        this.parameters.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        HttpMediaType httpMediaType;
        return object instanceof HttpMediaType && this.equalsIgnoreParameters(httpMediaType = (HttpMediaType)object) && this.parameters.equals(httpMediaType.parameters);
    }

    public boolean equalsIgnoreParameters(HttpMediaType httpMediaType) {
        return httpMediaType != null && this.getType().equalsIgnoreCase(httpMediaType.getType()) && this.getSubType().equalsIgnoreCase(httpMediaType.getSubType());
    }

    public Charset getCharsetParameter() {
        String string2 = this.getParameter("charset");
        if (string2 == null) {
            return null;
        }
        return Charset.forName(string2);
    }

    public String getParameter(String string2) {
        return (String)this.parameters.get(string2.toLowerCase());
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getSubType() {
        return this.subType;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return this.build().hashCode();
    }

    public HttpMediaType removeParameter(String string2) {
        this.cachedBuildResult = null;
        this.parameters.remove(string2.toLowerCase());
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public HttpMediaType setCharsetParameter(Charset charset) {
        String string2 = charset == null ? null : charset.name();
        this.setParameter("charset", string2);
        return this;
    }

    public HttpMediaType setParameter(String string2, String string3) {
        if (string3 == null) {
            this.removeParameter(string2);
            return this;
        }
        Preconditions.checkArgument(TOKEN_REGEX.matcher(string2).matches(), "Name contains reserved characters");
        this.cachedBuildResult = null;
        this.parameters.put(string2.toLowerCase(), string3);
        return this;
    }

    public HttpMediaType setSubType(String string2) {
        Preconditions.checkArgument(TYPE_REGEX.matcher(string2).matches(), "Subtype contains reserved characters");
        this.subType = string2;
        this.cachedBuildResult = null;
        return this;
    }

    public HttpMediaType setType(String string2) {
        Preconditions.checkArgument(TYPE_REGEX.matcher(string2).matches(), "Type contains reserved characters");
        this.type = string2;
        this.cachedBuildResult = null;
        return this;
    }

    public String toString() {
        return this.build();
    }
}

