/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.util.ArrayValueMap;
import com.google.api.client.util.Base64;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.Data;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.StringUtils;
import com.google.api.client.util.Throwables;
import com.google.api.client.util.Types;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpHeaders
extends GenericData {
    @Key(value="Accept")
    private List<String> accept;
    @Key(value="Accept-Encoding")
    private List<String> acceptEncoding = new ArrayList<String>(Collections.singleton("gzip"));
    @Key(value="Age")
    private List<Long> age;
    @Key(value="WWW-Authenticate")
    private List<String> authenticate;
    @Key(value="Authorization")
    private List<String> authorization;
    @Key(value="Cache-Control")
    private List<String> cacheControl;
    @Key(value="Content-Encoding")
    private List<String> contentEncoding;
    @Key(value="Content-Length")
    private List<Long> contentLength;
    @Key(value="Content-MD5")
    private List<String> contentMD5;
    @Key(value="Content-Range")
    private List<String> contentRange;
    @Key(value="Content-Type")
    private List<String> contentType;
    @Key(value="Cookie")
    private List<String> cookie;
    @Key(value="Date")
    private List<String> date;
    @Key(value="ETag")
    private List<String> etag;
    @Key(value="Expires")
    private List<String> expires;
    @Key(value="If-Match")
    private List<String> ifMatch;
    @Key(value="If-Modified-Since")
    private List<String> ifModifiedSince;
    @Key(value="If-None-Match")
    private List<String> ifNoneMatch;
    @Key(value="If-Range")
    private List<String> ifRange;
    @Key(value="If-Unmodified-Since")
    private List<String> ifUnmodifiedSince;
    @Key(value="Last-Modified")
    private List<String> lastModified;
    @Key(value="Location")
    private List<String> location;
    @Key(value="MIME-Version")
    private List<String> mimeVersion;
    @Key(value="Range")
    private List<String> range;
    @Key(value="Retry-After")
    private List<String> retryAfter;
    @Key(value="User-Agent")
    private List<String> userAgent;

    public HttpHeaders() {
        super(EnumSet.of(GenericData.Flags.IGNORE_CASE));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void addHeader(Logger logger, StringBuilder stringBuilder, StringBuilder stringBuilder2, LowLevelHttpRequest lowLevelHttpRequest, String string2, Object object, Writer writer) throws IOException {
        String string3;
        block8: {
            block7: {
                if (object == null || Data.isNull(object)) break block7;
                String string4 = string3 = HttpHeaders.toStringValue(object);
                if (!(!"Authorization".equalsIgnoreCase(string2) && !"Cookie".equalsIgnoreCase(string2) || logger != null && logger.isLoggable(Level.ALL))) {
                    string4 = "<Not Logged>";
                }
                if (stringBuilder != null) {
                    stringBuilder.append(string2).append(": ");
                    stringBuilder.append(string4);
                    stringBuilder.append(StringUtils.LINE_SEPARATOR);
                }
                if (stringBuilder2 != null) {
                    stringBuilder2.append(" -H '").append(string2).append(": ").append(string4).append("'");
                }
                if (lowLevelHttpRequest != null) {
                    lowLevelHttpRequest.addHeader(string2, string3);
                }
                if (writer != null) break block8;
            }
            return;
        }
        writer.write(string2);
        writer.write(": ");
        writer.write(string3);
        writer.write("\r\n");
    }

    private <T> List<T> getAsList(T t2) {
        if (t2 == null) {
            return null;
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.add(t2);
        return arrayList;
    }

    private <T> T getFirstHeaderValue(List<T> list) {
        if (list == null) {
            return null;
        }
        return list.get(0);
    }

    private static Object parseValue(Type type, List<Type> list, String string2) {
        return Data.parsePrimitiveValue(Data.resolveWildcardTypeOrTypeVariable(list, type), string2);
    }

    static void serializeHeaders(HttpHeaders httpHeaders, StringBuilder stringBuilder, StringBuilder stringBuilder2, Logger logger, LowLevelHttpRequest lowLevelHttpRequest) throws IOException {
        HttpHeaders.serializeHeaders(httpHeaders, stringBuilder, stringBuilder2, logger, lowLevelHttpRequest, null);
    }

    static void serializeHeaders(HttpHeaders httpHeaders, StringBuilder stringBuilder, StringBuilder stringBuilder2, Logger logger, LowLevelHttpRequest lowLevelHttpRequest, Writer writer) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, Object> entry : httpHeaders.entrySet()) {
            String string2 = entry.getKey();
            Preconditions.checkArgument(hashSet.add(string2), "multiple headers of the same name (headers are case insensitive): %s", string2);
            Object object = entry.getValue();
            if (object == null) continue;
            String string3 = string2;
            FieldInfo fieldInfo = httpHeaders.getClassInfo().getFieldInfo(string2);
            if (fieldInfo != null) {
                string3 = fieldInfo.getName();
            }
            Class<?> clazz = object.getClass();
            if (object instanceof Iterable || clazz.isArray()) {
                Iterator iterator = Types.iterableOf(object).iterator();
                while (iterator.hasNext()) {
                    HttpHeaders.addHeader(logger, stringBuilder, stringBuilder2, lowLevelHttpRequest, string3, iterator.next(), writer);
                }
                continue;
            }
            HttpHeaders.addHeader(logger, stringBuilder, stringBuilder2, lowLevelHttpRequest, string3, object, writer);
        }
        if (writer != null) {
            writer.flush();
        }
    }

    public static void serializeHeadersForMultipartRequests(HttpHeaders httpHeaders, StringBuilder stringBuilder, Logger logger, Writer writer) throws IOException {
        HttpHeaders.serializeHeaders(httpHeaders, stringBuilder, null, logger, null, writer);
    }

    private static String toStringValue(Object object) {
        if (object instanceof Enum) {
            return FieldInfo.of((Enum)object).getName();
        }
        return object.toString();
    }

    @Override
    public HttpHeaders clone() {
        return (HttpHeaders)super.clone();
    }

    public final void fromHttpHeaders(HttpHeaders httpHeaders) {
        try {
            ParseHeaderState parseHeaderState = new ParseHeaderState(this, null);
            HttpHeaders.serializeHeaders(httpHeaders, null, null, null, new HeaderParsingFakeLevelHttpRequest(this, parseHeaderState));
            parseHeaderState.finish();
            return;
        }
        catch (IOException iOException) {
            throw Throwables.propagate(iOException);
        }
    }

    public final void fromHttpResponse(LowLevelHttpResponse lowLevelHttpResponse, StringBuilder stringBuilder) throws IOException {
        this.clear();
        ParseHeaderState parseHeaderState = new ParseHeaderState(this, stringBuilder);
        int n2 = lowLevelHttpResponse.getHeaderCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.parseHeader(lowLevelHttpResponse.getHeaderName(i2), lowLevelHttpResponse.getHeaderValue(i2), parseHeaderState);
        }
        parseHeaderState.finish();
    }

    public final String getAccept() {
        return this.getFirstHeaderValue(this.accept);
    }

    public final String getAcceptEncoding() {
        return this.getFirstHeaderValue(this.acceptEncoding);
    }

    public final Long getAge() {
        return this.getFirstHeaderValue(this.age);
    }

    public final String getAuthenticate() {
        return this.getFirstHeaderValue(this.authenticate);
    }

    public final List<String> getAuthenticateAsList() {
        return this.authenticate;
    }

    public final String getAuthorization() {
        return this.getFirstHeaderValue(this.authorization);
    }

    public final List<String> getAuthorizationAsList() {
        return this.authorization;
    }

    public final String getCacheControl() {
        return this.getFirstHeaderValue(this.cacheControl);
    }

    public final String getContentEncoding() {
        return this.getFirstHeaderValue(this.contentEncoding);
    }

    public final Long getContentLength() {
        return this.getFirstHeaderValue(this.contentLength);
    }

    public final String getContentMD5() {
        return this.getFirstHeaderValue(this.contentMD5);
    }

    public final String getContentRange() {
        return this.getFirstHeaderValue(this.contentRange);
    }

    public final String getContentType() {
        return this.getFirstHeaderValue(this.contentType);
    }

    public final String getCookie() {
        return this.getFirstHeaderValue(this.cookie);
    }

    public final String getDate() {
        return this.getFirstHeaderValue(this.date);
    }

    public final String getETag() {
        return this.getFirstHeaderValue(this.etag);
    }

    public final String getExpires() {
        return this.getFirstHeaderValue(this.expires);
    }

    public String getFirstHeaderStringValue(String string2) {
        Iterator iterator;
        Object object = this.get(string2.toLowerCase());
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if ((object instanceof Iterable || clazz.isArray()) && (iterator = Types.iterableOf(object).iterator()).hasNext()) {
            return HttpHeaders.toStringValue(iterator.next());
        }
        return HttpHeaders.toStringValue(object);
    }

    public List<String> getHeaderStringValues(String string2) {
        Object object = this.get(string2.toLowerCase());
        if (object == null) {
            return Collections.emptyList();
        }
        Class<?> clazz = object.getClass();
        if (object instanceof Iterable || clazz.isArray()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = Types.iterableOf(object).iterator();
            while (iterator.hasNext()) {
                arrayList.add(HttpHeaders.toStringValue(iterator.next()));
            }
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.singletonList(HttpHeaders.toStringValue(object));
    }

    public final String getIfMatch() {
        return this.getFirstHeaderValue(this.ifMatch);
    }

    public final String getIfModifiedSince() {
        return this.getFirstHeaderValue(this.ifModifiedSince);
    }

    public final String getIfNoneMatch() {
        return this.getFirstHeaderValue(this.ifNoneMatch);
    }

    public final String getIfRange() {
        return this.getFirstHeaderValue(this.ifRange);
    }

    public final String getIfUnmodifiedSince() {
        return this.getFirstHeaderValue(this.ifUnmodifiedSince);
    }

    public final String getLastModified() {
        return this.getFirstHeaderValue(this.lastModified);
    }

    public final String getLocation() {
        return this.getFirstHeaderValue(this.location);
    }

    public final String getMimeVersion() {
        return this.getFirstHeaderValue(this.mimeVersion);
    }

    public final String getRange() {
        return this.getFirstHeaderValue(this.range);
    }

    public final String getRetryAfter() {
        return this.getFirstHeaderValue(this.retryAfter);
    }

    public final String getUserAgent() {
        return this.getFirstHeaderValue(this.userAgent);
    }

    /*
     * Enabled aggressive block sorting
     */
    void parseHeader(String string2, String string3, ParseHeaderState parseHeaderState) {
        FieldInfo fieldInfo;
        List<Type> list = parseHeaderState.context;
        ClassInfo classInfo = parseHeaderState.classInfo;
        ArrayValueMap arrayValueMap = parseHeaderState.arrayValueMap;
        StringBuilder stringBuilder = parseHeaderState.logger;
        if (stringBuilder != null) {
            stringBuilder.append(string2 + ": " + string3).append(StringUtils.LINE_SEPARATOR);
        }
        if ((fieldInfo = classInfo.getFieldInfo(string2)) != null) {
            Type type = Data.resolveWildcardTypeOrTypeVariable(list, fieldInfo.getGenericType());
            if (Types.isArray(type)) {
                Class<?> clazz = Types.getRawArrayComponentType(list, Types.getArrayComponentType(type));
                arrayValueMap.put(fieldInfo.getField(), clazz, HttpHeaders.parseValue(clazz, list, string3));
                return;
            }
            if (!Types.isAssignableToOrFrom(Types.getRawArrayComponentType(list, type), Iterable.class)) {
                fieldInfo.setValue(this, HttpHeaders.parseValue(type, list, string3));
                return;
            }
            Collection<Object> collection = (Collection<Object>)fieldInfo.getValue(this);
            if (collection == null) {
                collection = Data.newCollectionInstance(type);
                fieldInfo.setValue(this, collection);
            }
            Type type2 = type == Object.class ? null : Types.getIterableParameter(type);
            collection.add(HttpHeaders.parseValue(type2, list, string3));
            return;
        }
        ArrayList<String> arrayList = (ArrayList<String>)this.get(string2);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this.set(string2, arrayList);
        }
        arrayList.add(string3);
    }

    @Override
    public HttpHeaders set(String string2, Object object) {
        return (HttpHeaders)super.set(string2, object);
    }

    public HttpHeaders setAccept(String string2) {
        this.accept = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setAcceptEncoding(String string2) {
        this.acceptEncoding = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setAge(Long l2) {
        this.age = this.getAsList(l2);
        return this;
    }

    public HttpHeaders setAuthenticate(String string2) {
        this.authenticate = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setAuthorization(String string2) {
        return this.setAuthorization(this.getAsList(string2));
    }

    public HttpHeaders setAuthorization(List<String> list) {
        this.authorization = list;
        return this;
    }

    public HttpHeaders setBasicAuthentication(String string2, String string3) {
        String string4 = Base64.encodeBase64String(StringUtils.getBytesUtf8(Preconditions.checkNotNull(string2) + ":" + Preconditions.checkNotNull(string3)));
        return this.setAuthorization("Basic " + string4);
    }

    public HttpHeaders setCacheControl(String string2) {
        this.cacheControl = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setContentEncoding(String string2) {
        this.contentEncoding = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setContentLength(Long l2) {
        this.contentLength = this.getAsList(l2);
        return this;
    }

    public HttpHeaders setContentMD5(String string2) {
        this.contentMD5 = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setContentRange(String string2) {
        this.contentRange = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setContentType(String string2) {
        this.contentType = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setCookie(String string2) {
        this.cookie = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setDate(String string2) {
        this.date = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setETag(String string2) {
        this.etag = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setExpires(String string2) {
        this.expires = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setIfMatch(String string2) {
        this.ifMatch = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setIfModifiedSince(String string2) {
        this.ifModifiedSince = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setIfNoneMatch(String string2) {
        this.ifNoneMatch = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setIfRange(String string2) {
        this.ifRange = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setIfUnmodifiedSince(String string2) {
        this.ifUnmodifiedSince = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setLastModified(String string2) {
        this.lastModified = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setLocation(String string2) {
        this.location = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setMimeVersion(String string2) {
        this.mimeVersion = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setRange(String string2) {
        this.range = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setRetryAfter(String string2) {
        this.retryAfter = this.getAsList(string2);
        return this;
    }

    public HttpHeaders setUserAgent(String string2) {
        this.userAgent = this.getAsList(string2);
        return this;
    }

    private static class HeaderParsingFakeLevelHttpRequest
    extends LowLevelHttpRequest {
        private final ParseHeaderState state;
        private final HttpHeaders target;

        HeaderParsingFakeLevelHttpRequest(HttpHeaders httpHeaders, ParseHeaderState parseHeaderState) {
            this.target = httpHeaders;
            this.state = parseHeaderState;
        }

        @Override
        public void addHeader(String string2, String string3) {
            this.target.parseHeader(string2, string3, this.state);
        }

        @Override
        public LowLevelHttpResponse execute() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ParseHeaderState {
        final ArrayValueMap arrayValueMap;
        final ClassInfo classInfo;
        final List<Type> context;
        final StringBuilder logger;

        public ParseHeaderState(HttpHeaders httpHeaders, StringBuilder stringBuilder) {
            Class<?> clazz = httpHeaders.getClass();
            this.context = Arrays.asList(clazz);
            this.classInfo = ClassInfo.of(clazz, true);
            this.logger = stringBuilder;
            this.arrayValueMap = new ArrayValueMap(httpHeaders);
        }

        void finish() {
            this.arrayValueMap.setValues();
        }
    }
}

