/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.UrlEncodedParser;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.escape.CharEscapers;
import com.google.api.client.util.escape.Escaper;
import com.google.api.client.util.escape.PercentEscaper;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenericUrl
extends GenericData {
    private static final Escaper URI_FRAGMENT_ESCAPER = new PercentEscaper("=&-_.!~*'()@:$,;/?:", false);
    private String fragment;
    private String host;
    private List<String> pathParts;
    private int port = -1;
    private String scheme;
    private String userInfo;

    public GenericUrl() {
    }

    public GenericUrl(String string2) {
        this(GenericUrl.parseURL(string2));
    }

    /*
     * Enabled aggressive block sorting
     */
    private GenericUrl(String string2, String string3, int n2, String string4, String string5, String string6, String string7) {
        this.scheme = string2.toLowerCase();
        this.host = string3;
        this.port = n2;
        this.pathParts = GenericUrl.toPathParts(string4);
        String string8 = string5 != null ? CharEscapers.decodeUri(string5) : null;
        this.fragment = string8;
        if (string6 != null) {
            UrlEncodedParser.parse(string6, (Object)this);
        }
        String string9 = null;
        if (string7 != null) {
            string9 = CharEscapers.decodeUri(string7);
        }
        this.userInfo = string9;
    }

    public GenericUrl(URI uRI) {
        this(uRI.getScheme(), uRI.getHost(), uRI.getPort(), uRI.getRawPath(), uRI.getRawFragment(), uRI.getRawQuery(), uRI.getRawUserInfo());
    }

    public GenericUrl(URL uRL) {
        this(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getPath(), uRL.getRef(), uRL.getQuery(), uRL.getUserInfo());
    }

    static void addQueryParams(Set<Map.Entry<String, Object>> set, StringBuilder stringBuilder) {
        boolean bl2 = true;
        for (Map.Entry<String, Object> entry : set) {
            Object object = entry.getValue();
            if (object == null) continue;
            String string2 = CharEscapers.escapeUriQuery(entry.getKey());
            if (object instanceof Collection) {
                Iterator iterator = ((Collection)object).iterator();
                while (iterator.hasNext()) {
                    bl2 = GenericUrl.appendParam(bl2, stringBuilder, string2, iterator.next());
                }
                continue;
            }
            bl2 = GenericUrl.appendParam(bl2, stringBuilder, string2, object);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean appendParam(boolean bl2, StringBuilder stringBuilder, String string2, Object object) {
        if (bl2) {
            bl2 = false;
            stringBuilder.append('?');
        } else {
            stringBuilder.append('&');
        }
        stringBuilder.append(string2);
        String string3 = CharEscapers.escapeUriQuery(object.toString());
        if (string3.length() != 0) {
            stringBuilder.append('=').append(string3);
        }
        return bl2;
    }

    private void appendRawPathFromParts(StringBuilder stringBuilder) {
        int n2 = this.pathParts.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = this.pathParts.get(i2);
            if (i2 != 0) {
                stringBuilder.append('/');
            }
            if (string2.length() == 0) continue;
            stringBuilder.append(CharEscapers.escapeUriPath(string2));
        }
    }

    private static URL parseURL(String string2) {
        try {
            URL uRL = new URL(string2);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<String> toPathParts(String string2) {
        if (string2 == null) return null;
        if (string2.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        boolean bl2 = true;
        while (bl2) {
            int n3 = string2.indexOf(47, n2);
            bl2 = n3 != -1;
            String string3 = bl2 ? string2.substring(n2, n3) : string2.substring(n2);
            arrayList.add(CharEscapers.decodeUri(string3));
            n2 = n3 + 1;
        }
        return arrayList;
    }

    private static URI toURI(String string2) {
        try {
            URI uRI = new URI(string2);
            return uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    public void appendRawPath(String string2) {
        List<String> list;
        block3: {
            block2: {
                if (string2 == null || string2.length() == 0) break block2;
                list = GenericUrl.toPathParts(string2);
                if (this.pathParts != null && !this.pathParts.isEmpty()) break block3;
                this.pathParts = list;
            }
            return;
        }
        int n2 = this.pathParts.size();
        this.pathParts.set(n2 - 1, this.pathParts.get(n2 - 1) + list.get(0));
        this.pathParts.addAll(list.subList(1, list.size()));
    }

    public final String build() {
        return this.buildAuthority() + this.buildRelativeUrl();
    }

    public final String buildAuthority() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Preconditions.checkNotNull(this.scheme));
        stringBuilder.append("://");
        if (this.userInfo != null) {
            stringBuilder.append(CharEscapers.escapeUriUserInfo(this.userInfo)).append('@');
        }
        stringBuilder.append(Preconditions.checkNotNull(this.host));
        int n2 = this.port;
        if (n2 != -1) {
            stringBuilder.append(':').append(n2);
        }
        return stringBuilder.toString();
    }

    public final String buildRelativeUrl() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.pathParts != null) {
            this.appendRawPathFromParts(stringBuilder);
        }
        GenericUrl.addQueryParams(this.entrySet(), stringBuilder);
        String string2 = this.fragment;
        if (string2 != null) {
            stringBuilder.append('#').append(URI_FRAGMENT_ESCAPER.escape(string2));
        }
        return stringBuilder.toString();
    }

    @Override
    public GenericUrl clone() {
        GenericUrl genericUrl = (GenericUrl)super.clone();
        if (this.pathParts != null) {
            genericUrl.pathParts = new ArrayList<String>(this.pathParts);
        }
        return genericUrl;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object) || !(object instanceof GenericUrl)) {
            return false;
        }
        GenericUrl genericUrl = (GenericUrl)object;
        return this.build().equals(genericUrl.toString());
    }

    public Collection<Object> getAll(String string2) {
        Object object = this.get(string2);
        if (object == null) {
            return Collections.emptySet();
        }
        if (object instanceof Collection) {
            return Collections.unmodifiableCollection((Collection)object);
        }
        return Collections.singleton(object);
    }

    public Object getFirst(String string2) {
        Object object = this.get(string2);
        if (object instanceof Collection) {
            Iterator iterator = ((Collection)object).iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return null;
        }
        return object;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getHost() {
        return this.host;
    }

    public List<String> getPathParts() {
        return this.pathParts;
    }

    public int getPort() {
        return this.port;
    }

    public String getRawPath() {
        if (this.pathParts == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.appendRawPathFromParts(stringBuilder);
        return stringBuilder.toString();
    }

    public final String getScheme() {
        return this.scheme;
    }

    public final String getUserInfo() {
        return this.userInfo;
    }

    @Override
    public int hashCode() {
        return this.build().hashCode();
    }

    @Override
    public GenericUrl set(String string2, Object object) {
        return (GenericUrl)super.set(string2, object);
    }

    public final void setFragment(String string2) {
        this.fragment = string2;
    }

    public final void setHost(String string2) {
        this.host = Preconditions.checkNotNull(string2);
    }

    public void setPathParts(List<String> list) {
        this.pathParts = list;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void setPort(int n2) {
        boolean bl2 = n2 >= -1;
        Preconditions.checkArgument(bl2, "expected port >= -1");
        this.port = n2;
    }

    public void setRawPath(String string2) {
        this.pathParts = GenericUrl.toPathParts(string2);
    }

    public final void setScheme(String string2) {
        this.scheme = Preconditions.checkNotNull(string2);
    }

    public final void setUserInfo(String string2) {
        this.userInfo = string2;
    }

    @Override
    public String toString() {
        return this.build();
    }

    public final URI toURI() {
        return GenericUrl.toURI(this.build());
    }

    public final URL toURL() {
        return GenericUrl.parseURL(this.build());
    }

    public final URL toURL(String string2) {
        try {
            URL uRL = new URL(this.toURL(), string2);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
    }
}

