/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public final class ByteArrayContent
extends AbstractInputStreamContent {
    private final byte[] byteArray;
    private final int length;
    private final int offset;

    public ByteArrayContent(String string2, byte[] byArray) {
        this(string2, byArray, 0, byArray.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ByteArrayContent(String string2, byte[] byArray, int n2, int n3) {
        super(string2);
        this.byteArray = Preconditions.checkNotNull(byArray);
        boolean bl2 = n2 >= 0 && n3 >= 0 && n2 + n3 <= byArray.length;
        Object[] objectArray = new Object[]{n2, n3, byArray.length};
        Preconditions.checkArgument(bl2, "offset %s, length %s, array length %s", objectArray);
        this.offset = n2;
        this.length = n3;
    }

    public static ByteArrayContent fromString(String string2, String string3) {
        return new ByteArrayContent(string2, StringUtils.getBytesUtf8(string3));
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.byteArray, this.offset, this.length);
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public boolean retrySupported() {
        return true;
    }

    @Override
    public ByteArrayContent setCloseInputStream(boolean bl2) {
        return (ByteArrayContent)super.setCloseInputStream(bl2);
    }

    @Override
    public ByteArrayContent setType(String string2) {
        return (ByteArrayContent)super.setType(string2);
    }
}

